/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.api.endpoints;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.pnc.dto.Artifact;
import org.jboss.pnc.dto.ArtifactRevision;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.dto.response.ArtifactInfo;
import org.jboss.pnc.dto.response.ErrorResponse;
import org.jboss.pnc.dto.response.MilestoneInfo;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.enums.ArtifactQuality;
import org.jboss.pnc.enums.BuildCategory;
import org.jboss.pnc.enums.RepositoryType;
import org.jboss.pnc.rest.annotation.RespondWithStatus;
import org.jboss.pnc.rest.api.parameters.PageParameters;
import org.jboss.pnc.rest.api.parameters.PaginationParameters;
import org.jboss.pnc.rest.api.swagger.response.SwaggerPages;

@Tag(name="Artifacts")
@Path(value="/artifacts")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface ArtifactEndpoint {
    public static final String A_ID = "ID of the artifact";
    public static final String A_REV = "Revision number of the artifact";
    public static final String GET_ALL_DESC = "Gets all artifacts.";
    public static final String FILTER_SHA256_DESC = "Filter by sha256 of the artifact.";
    public static final String FILTER_SHA1_DESC = "Filter by sha1 of the artifact.";
    public static final String FILTER_MD5_DESC = "Filter by md5 of the artifact.";
    public static final String GET_ALL_FILTERED_DESC = "Gets all artifacts according to specified filters.";
    public static final String FILTER_IDENTIFIER_DESC = "Filter by artifact identifier or its part.";
    public static final String FILTER_QUALITY_DESC = "List of artifact qualities to include in result.";
    public static final String FILTER_BUILD_CATEGORY_DESC = "List of artifact build categories to include in result.";
    public static final String FILTER_REPOSITORY_TYPE_DESC = "Type of target repository.";
    public static final String GET_SPECIFIC_DESC = "Gets a specific build config.";
    public static final String CREATE_DESC = "Creates a new Artifact.";
    public static final String UPDATE_DESC = "Updates an existing Artifact";
    public static final String CREATE_ARTIFACT_QUALITY_REVISION = "Add a new quality level revision for this artifact. Accepted values from standard users are NEW, VERIFIED, TESTED, DEPRECATED. Users with system-user role can also specify BLACKLISTED and DELETED quality levels.";
    public static final String ARTIFACT_QUALITY = "Quality level of the artifact.";
    public static final String ARTIFACT_QUALITY_REASON = "The reason for adding a new quality level for this artifact.";
    public static final String GET_DEPENDANT_BUILDS_DESC = "Gets the build(s) that depends on this artifact.";
    public static final String GET_MILESTONES_INFO_DESC = "Gets the milestones that produced or consumed this artifact.";
    public static final String GET_ARTIFACT_REVISIONS_DESC = "Gets audited revisions of this artifact.";
    public static final String GET_ARTIFACT_REVISION_DESC = "Get specific audited revision of this artifact.";

    @Operation(summary="Gets all artifacts.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.ArtifactPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    public Page<Artifact> getAll(@Valid @BeanParam PageParameters var1, @Parameter(description="Filter by sha256 of the artifact.") @QueryParam(value="sha256") String var2, @Parameter(description="Filter by md5 of the artifact.") @QueryParam(value="md5") String var3, @Parameter(description="Filter by sha1 of the artifact.") @QueryParam(value="sha1") String var4);

    @Operation(summary="Gets all artifacts according to specified filters.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.ArtifactInfoPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/filter")
    public Page<ArtifactInfo> getAllFiltered(@Valid @BeanParam PaginationParameters var1, @Parameter(description="Filter by artifact identifier or its part.") @QueryParam(value="identifier") String var2, @Parameter(description="List of artifact qualities to include in result.") @QueryParam(value="qualities") Set<ArtifactQuality> var3, @Parameter(description="Type of target repository.") @QueryParam(value="repoType") RepositoryType var4, @Parameter(description="List of artifact build categories to include in result.") @QueryParam(value="buildCategories") Set<BuildCategory> var5);

    @Operation(summary="Gets a specific build config.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=Artifact.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}")
    public Artifact getSpecific(@Parameter(description="ID of the Artifact") @PathParam(value="id") String var1);

    @Operation(summary="[role:admin] Creates a new Artifact.", tags={"Internal"}, responses={@ApiResponse(responseCode="201", description="Entity successfully created", content={@Content(schema=@Schema(implementation=Artifact.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.CREATED)
    public Artifact create(@NotNull Artifact var1);

    @Operation(summary="[role:admin] Updates an existing Artifact", tags={"Internal"}, responses={@ApiResponse(responseCode="204", description="Entity successfully updated"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @PUT
    @Path(value="/{id}")
    public void update(@PathParam(value="id") String var1, @NotNull Artifact var2);

    @Operation(summary="Add a new quality level revision for this artifact. Accepted values from standard users are NEW, VERIFIED, TESTED, DEPRECATED. Users with system-user role can also specify BLACKLISTED and DELETED quality levels.", responses={@ApiResponse(responseCode="201", description="Entity successfully created", content={@Content(schema=@Schema(implementation=ArtifactRevision.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.CREATED)
    @Path(value="/{id}/artifacts/quality")
    public ArtifactRevision createQualityLevelRevision(@Parameter(description="ID of the artifact") @PathParam(value="id") String var1, @Parameter(description="Quality level of the artifact.", required=true) @QueryParam(value="quality") String var2, @Parameter(description="The reason for adding a new quality level for this artifact.", required=true) @QueryParam(value="reason") String var3);

    @Operation(summary="Gets the build(s) that depends on this artifact.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.BuildPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/dependant-builds")
    public Page<Build> getDependantBuilds(@Parameter(description="ID of the artifact") @PathParam(value="id") String var1, @BeanParam PageParameters var2);

    @Operation(summary="Gets the milestones that produced or consumed this artifact.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.MilestoneInfoPage.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/milestones")
    public Page<MilestoneInfo> getMilestonesInfo(@Parameter(description="ID of the artifact") @PathParam(value="id") String var1, @BeanParam PaginationParameters var2);

    @Operation(summary="Gets audited revisions of this artifact.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.ArtifactRevisionPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/revisions")
    public Page<ArtifactRevision> getRevisions(@Parameter(description="ID of the artifact") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2);

    @Operation(summary="Get specific audited revision of this artifact.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=ArtifactRevision.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/revisions/{rev}")
    public ArtifactRevision getRevision(@Parameter(description="ID of the artifact") @PathParam(value="id") String var1, @Parameter(description="Revision number of the artifact") @PathParam(value="rev") int var2);
}

