/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.api.endpoints;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jboss.pnc.api.enums.OperationResult;
import org.jboss.pnc.dto.DeliverableAnalyzerOperation;
import org.jboss.pnc.dto.Product;
import org.jboss.pnc.dto.response.ErrorResponse;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.rest.api.parameters.PageParameters;
import org.jboss.pnc.rest.api.swagger.response.SwaggerPages;

@Tag(name="Operations")
@Path(value="/operations")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface OperationEndpoint {
    public static final String GET_ALL_DELIVERABLE_ANALYZER_OPERATIONS_DESC = "Gets all deliverable analyzer operations.";
    public static final String COMPLETE_OPERATION_DESC = "Complete a running operation.";
    public static final String OPERATION_RESULT = "Result of completed operation.";
    public static final String UPDATE_DEL_ANALYZER_DESC = "Updates an existing deliverable analyzer operation.";
    public static final String GET_SPECIFIC_DEL_ANALYZER_DESC = "Gets a specific delivarable analyzer operation.";
    public static final String OP_ID = "ID of the operation";

    @Operation(summary="Complete a running operation.", tags={"Internal"}, responses={@ApiResponse(responseCode="204", description="Entity successfully updated"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @Path(value="/{id}/complete")
    public void finish(@Parameter(description="ID of the operation") @PathParam(value="id") String var1, @Parameter(description="Result of completed operation.", required=true) @QueryParam(value="result") OperationResult var2);

    @Operation(summary="[role:admin] Updates an existing deliverable analyzer operation.", tags={"Internal"}, responses={@ApiResponse(responseCode="204", description="Entity successfully updated"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @PUT
    @Path(value="/deliverable-analyzer/{id}")
    public DeliverableAnalyzerOperation updateDeliverableAnalyzer(@Parameter(description="ID of the operation") @PathParam(value="id") String var1, @NotNull DeliverableAnalyzerOperation var2);

    @Operation(summary="Gets a specific delivarable analyzer operation.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=Product.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/deliverable-analyzer/{id}")
    @Consumes(value={"application/json-patch+json"})
    public DeliverableAnalyzerOperation getSpecificDeliverableAnalyzer(@Parameter(description="ID of the operation") @PathParam(value="id") String var1);

    @Operation(summary="Gets all deliverable analyzer operations.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.DeliverableAnalyzerOperationPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/deliverable-analyzer")
    public Page<DeliverableAnalyzerOperation> getAllDeliverableAnalyzerOperation(@Valid @BeanParam PageParameters var1);
}

