/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.api.endpoints;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.pnc.dto.ProductRelease;
import org.jboss.pnc.dto.response.ErrorResponse;
import org.jboss.pnc.enums.SupportLevel;
import org.jboss.pnc.rest.annotation.RespondWithStatus;

@Tag(name="Product Releases")
@Path(value="/product-releases")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface ProductReleaseEndpoint {
    public static final String PR_ID = "ID of the product release";
    public static final String CREATE_NEW_DESC = "Creates a new product release.";
    public static final String GET_SPECIFIC_DESC = "Gets a specific product release.";
    public static final String UPDATE_DESC = "Updates an existing product release.";
    public static final String PATCH_SPECIFIC_DESC = "Patch an existing product release.";
    public static final String GET_SUPPORT_LEVELS = "Gets all product releases support levels.";

    @Operation(summary="Creates a new product release.", responses={@ApiResponse(responseCode="201", description="Entity successfully created", content={@Content(schema=@Schema(implementation=ProductRelease.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.CREATED)
    public ProductRelease createNew(@NotNull ProductRelease var1);

    @Operation(summary="Gets a specific product release.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=ProductRelease.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}")
    @Consumes(value={"application/json-patch+json"})
    public ProductRelease getSpecific(@Parameter(description="ID of the product release") @PathParam(value="id") String var1);

    @Operation(summary="Updates an existing product release.", responses={@ApiResponse(responseCode="204", description="Entity successfully updated"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @PUT
    @Path(value="/{id}")
    public void update(@Parameter(description="ID of the product release") @PathParam(value="id") String var1, @NotNull ProductRelease var2);

    @Operation(summary="Patch an existing product release.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=ProductRelease.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @PATCH
    @Path(value="/{id}")
    @Consumes(value={"application/json-patch+json"})
    public ProductRelease patchSpecific(@Parameter(description="ID of the product release") @PathParam(value="id") String var1, @NotNull ProductRelease var2);

    @Operation(summary="Gets all product releases support levels.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SupportLevel.class)))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/support-levels")
    public Set<SupportLevel> getSupportLevels();
}

