package org.jboss.pnc.client;

import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.pnc.rest.api.endpoints.CacheEndpoint;

public class CacheClient extends ClientBase<CacheEndpoint> {
  public CacheClient(Configuration configuration) {
    super(configuration, CacheEndpoint.class);
  }

  public Response getGenericStats() throws RemoteResourceException {
    try {
      return getEndpoint().getGenericStats();
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          return getEndpoint().getGenericStats();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public Response getSecondLevelCacheEntitiesStats() throws RemoteResourceException {
    try {
      return getEndpoint().getSecondLevelCacheEntitiesStats();
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          return getEndpoint().getSecondLevelCacheEntitiesStats();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public Response getSecondLevelCacheRegionsStats() throws RemoteResourceException {
    try {
      return getEndpoint().getSecondLevelCacheRegionsStats();
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          return getEndpoint().getSecondLevelCacheRegionsStats();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public Response getSecondLevelCacheCollectionsStats() throws RemoteResourceException {
    try {
      return getEndpoint().getSecondLevelCacheCollectionsStats();
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          return getEndpoint().getSecondLevelCacheCollectionsStats();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public Response clearCache() throws RemoteResourceException {
    try {
      return getEndpoint().clearCache();
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          return getEndpoint().clearCache();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }
}
