/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.client;

import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.util.Map;
import org.jboss.pnc.common.util.StringUtils;
import org.slf4j.MDC;

public class MdcToHeadersFilter
implements ClientRequestFilter {
    private Map<String, String> mappings;

    public MdcToHeadersFilter(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        MultivaluedMap headers = requestContext.getHeaders();
        Map context = MDC.getCopyOfContextMap();
        if (context == null) {
            return;
        }
        for (Map.Entry<String, String> mdcKeyHeaderKey : this.mappings.entrySet()) {
            String mdcValue = (String)context.get(mdcKeyHeaderKey.getKey());
            if (StringUtils.isEmpty((String)mdcValue) || headers.containsKey((Object)mdcKeyHeaderKey.getValue())) continue;
            headers.add((Object)mdcKeyHeaderKey.getValue(), (Object)mdcValue);
        }
    }
}

