/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.api.parameters;

import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import org.jboss.pnc.api.enums.AlignmentPreference;
import org.jboss.pnc.enums.RebuildMode;
import org.jboss.pnc.rest.validation.GroupBuildParametersConstraint;

@GroupBuildParametersConstraint
public class GroupBuildParameters {
    @Parameter(description="Is it a temporary build or a standard build?")
    @QueryParam(value="temporaryBuild")
    @DefaultValue(value="false")
    boolean temporaryBuild;
    @Parameter(description="IMPLICIT_DEPENDENCY_CHECK")
    @QueryParam(value="rebuildMode")
    @DefaultValue(value="IMPLICIT_DEPENDENCY_CHECK")
    RebuildMode rebuildMode;
    @Parameter(description="This feature was disabled. Setting this value has no effect on the build.")
    @QueryParam(value="timestampAlignment")
    @DefaultValue(value="false")
    boolean timestampAlignment;
    @Parameter(description="Defines temporary build dependency alignment preferences. Default: PREFER_TEMPORARY.")
    @QueryParam(value="alignmentPreference")
    AlignmentPreference alignmentPreference;

    public AlignmentPreference getAlignmentPreference() {
        if (this.alignmentPreference == null && this.isTemporaryBuild()) {
            return AlignmentPreference.PREFER_TEMPORARY;
        }
        return this.alignmentPreference;
    }

    public boolean isTemporaryBuild() {
        return this.temporaryBuild;
    }

    public RebuildMode getRebuildMode() {
        return this.rebuildMode;
    }

    public boolean isTimestampAlignment() {
        return this.timestampAlignment;
    }

    public void setTemporaryBuild(boolean temporaryBuild) {
        this.temporaryBuild = temporaryBuild;
    }

    public void setRebuildMode(RebuildMode rebuildMode) {
        this.rebuildMode = rebuildMode;
    }

    public void setTimestampAlignment(boolean timestampAlignment) {
        this.timestampAlignment = timestampAlignment;
    }

    public void setAlignmentPreference(AlignmentPreference alignmentPreference) {
        this.alignmentPreference = alignmentPreference;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupBuildParameters)) {
            return false;
        }
        GroupBuildParameters other = (GroupBuildParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTemporaryBuild() != other.isTemporaryBuild()) {
            return false;
        }
        if (this.isTimestampAlignment() != other.isTimestampAlignment()) {
            return false;
        }
        RebuildMode this$rebuildMode = this.getRebuildMode();
        RebuildMode other$rebuildMode = other.getRebuildMode();
        if (this$rebuildMode == null ? other$rebuildMode != null : !this$rebuildMode.equals(other$rebuildMode)) {
            return false;
        }
        AlignmentPreference this$alignmentPreference = this.getAlignmentPreference();
        AlignmentPreference other$alignmentPreference = other.getAlignmentPreference();
        return !(this$alignmentPreference == null ? other$alignmentPreference != null : !this$alignmentPreference.equals(other$alignmentPreference));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupBuildParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTemporaryBuild() ? 79 : 97);
        result = result * 59 + (this.isTimestampAlignment() ? 79 : 97);
        RebuildMode $rebuildMode = this.getRebuildMode();
        result = result * 59 + ($rebuildMode == null ? 43 : $rebuildMode.hashCode());
        AlignmentPreference $alignmentPreference = this.getAlignmentPreference();
        result = result * 59 + ($alignmentPreference == null ? 43 : $alignmentPreference.hashCode());
        return result;
    }

    public String toString() {
        return "GroupBuildParameters(temporaryBuild=" + this.isTemporaryBuild() + ", rebuildMode=" + this.getRebuildMode() + ", timestampAlignment=" + this.isTimestampAlignment() + ", alignmentPreference=" + this.getAlignmentPreference() + ")";
    }
}

