/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.client;

import java.util.Optional;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.jboss.pnc.client.ClientBase;
import org.jboss.pnc.client.Configuration;
import org.jboss.pnc.client.PageReader;
import org.jboss.pnc.client.RemoteCollection;
import org.jboss.pnc.client.RemoteResourceException;
import org.jboss.pnc.client.RemoteResourceNotFoundException;
import org.jboss.pnc.dto.DeliverableAnalyzerLabelEntry;
import org.jboss.pnc.dto.DeliverableAnalyzerReport;
import org.jboss.pnc.dto.requests.labels.DeliverableAnalyzerReportLabelRequest;
import org.jboss.pnc.dto.response.AnalyzedArtifact;
import org.jboss.pnc.rest.api.endpoints.DeliverableAnalyzerReportEndpoint;
import org.jboss.pnc.rest.api.parameters.PageParameters;

public class DeliverableAnalyzerReportClient
extends ClientBase<DeliverableAnalyzerReportEndpoint> {
    public DeliverableAnalyzerReportClient(Configuration configuration) {
        super(configuration, DeliverableAnalyzerReportEndpoint.class);
    }

    public RemoteCollection<DeliverableAnalyzerReport> getAll(Optional<String> sort, Optional<String> query) throws RemoteResourceException {
        try {
            PageReader pageLoader = new PageReader(pageParameters -> {
                this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                return ((DeliverableAnalyzerReportEndpoint)this.getEndpoint()).getAll((PageParameters)pageParameters);
            }, this.getRemoteCollectionConfig());
            return pageLoader.getCollection();
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    PageReader pageLoader = new PageReader(pageParameters -> {
                        this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                        return ((DeliverableAnalyzerReportEndpoint)this.getEndpoint()).getAll((PageParameters)pageParameters);
                    }, this.getRemoteCollectionConfig());
                    return pageLoader.getCollection();
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public RemoteCollection<DeliverableAnalyzerReport> getAll() throws RemoteResourceException {
        try {
            return this.getAll(Optional.empty(), Optional.empty());
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    return this.getAll(Optional.empty(), Optional.empty());
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public DeliverableAnalyzerReport getSpecific(String id) throws RemoteResourceException {
        try {
            return ((DeliverableAnalyzerReportEndpoint)this.getEndpoint()).getSpecific(id);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    return ((DeliverableAnalyzerReportEndpoint)this.getEndpoint()).getSpecific(id);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public RemoteCollection<AnalyzedArtifact> getAnalyzedArtifacts(String id, Optional<String> sort, Optional<String> query) throws RemoteResourceException {
        try {
            PageReader pageLoader = new PageReader(pageParameters -> {
                this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                return ((DeliverableAnalyzerReportEndpoint)this.getEndpoint()).getAnalyzedArtifacts(id, (PageParameters)pageParameters);
            }, this.getRemoteCollectionConfig());
            return pageLoader.getCollection();
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    PageReader pageLoader = new PageReader(pageParameters -> {
                        this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                        return ((DeliverableAnalyzerReportEndpoint)this.getEndpoint()).getAnalyzedArtifacts(id, (PageParameters)pageParameters);
                    }, this.getRemoteCollectionConfig());
                    return pageLoader.getCollection();
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public RemoteCollection<AnalyzedArtifact> getAnalyzedArtifacts(String id) throws RemoteResourceException {
        try {
            return this.getAnalyzedArtifacts(id, Optional.empty(), Optional.empty());
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    return this.getAnalyzedArtifacts(id, Optional.empty(), Optional.empty());
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public void addLabel(String id, DeliverableAnalyzerReportLabelRequest request) throws RemoteResourceException, RemoteResourceNotFoundException {
        try {
            ((DeliverableAnalyzerReportEndpoint)this.getEndpoint()).addLabel(id, request);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    ((DeliverableAnalyzerReportEndpoint)this.getEndpoint()).addLabel(id, request);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public void removeLabel(String id, DeliverableAnalyzerReportLabelRequest request) throws RemoteResourceException, RemoteResourceNotFoundException {
        try {
            ((DeliverableAnalyzerReportEndpoint)this.getEndpoint()).removeLabel(id, request);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    ((DeliverableAnalyzerReportEndpoint)this.getEndpoint()).removeLabel(id, request);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public RemoteCollection<DeliverableAnalyzerLabelEntry> getLabelHistory(String id, Optional<String> sort, Optional<String> query) throws RemoteResourceException {
        try {
            PageReader pageLoader = new PageReader(pageParameters -> {
                this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                return ((DeliverableAnalyzerReportEndpoint)this.getEndpoint()).getLabelHistory(id, (PageParameters)pageParameters);
            }, this.getRemoteCollectionConfig());
            return pageLoader.getCollection();
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    PageReader pageLoader = new PageReader(pageParameters -> {
                        this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                        return ((DeliverableAnalyzerReportEndpoint)this.getEndpoint()).getLabelHistory(id, (PageParameters)pageParameters);
                    }, this.getRemoteCollectionConfig());
                    return pageLoader.getCollection();
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public RemoteCollection<DeliverableAnalyzerLabelEntry> getLabelHistory(String id) throws RemoteResourceException {
        try {
            return this.getLabelHistory(id, Optional.empty(), Optional.empty());
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    return this.getLabelHistory(id, Optional.empty(), Optional.empty());
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }
}

