/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.client;

import javax.ws.rs.ClientErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.jboss.pnc.client.ClientBase;
import org.jboss.pnc.client.Configuration;
import org.jboss.pnc.client.RemoteResourceException;
import org.jboss.pnc.client.RemoteResourceNotFoundException;
import org.jboss.pnc.dto.PncStatus;
import org.jboss.pnc.rest.api.endpoints.PncStatusEndpoint;

public class PncStatusClient
extends ClientBase<PncStatusEndpoint> {
    public PncStatusClient(Configuration configuration) {
        super(configuration, PncStatusEndpoint.class);
    }

    public void setPncStatus(PncStatus pncStatus) throws RemoteResourceException, RemoteResourceNotFoundException {
        try {
            ((PncStatusEndpoint)this.getEndpoint()).setPncStatus(pncStatus);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    ((PncStatusEndpoint)this.getEndpoint()).setPncStatus(pncStatus);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public PncStatus getPncStatus() throws RemoteResourceException {
        try {
            return ((PncStatusEndpoint)this.getEndpoint()).getPncStatus();
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    return ((PncStatusEndpoint)this.getEndpoint()).getPncStatus();
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }
}

