/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.api.endpoints;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.dto.BuildConfiguration;
import org.jboss.pnc.dto.BuildConfigurationRef;
import org.jboss.pnc.dto.GroupBuild;
import org.jboss.pnc.dto.GroupConfiguration;
import org.jboss.pnc.dto.requests.GroupBuildRequest;
import org.jboss.pnc.dto.response.ErrorResponse;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.rest.annotation.RespondWithStatus;
import org.jboss.pnc.rest.api.parameters.BuildsFilterParameters;
import org.jboss.pnc.rest.api.parameters.GroupBuildParameters;
import org.jboss.pnc.rest.api.parameters.GroupBuildsFilterParameters;
import org.jboss.pnc.rest.api.parameters.PageParameters;
import org.jboss.pnc.rest.api.swagger.response.SwaggerPages;

@Tag(name="Group Configs")
@Path(value="/group-configs")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface GroupConfigurationEndpoint {
    public static final String GC_ID = "ID of the group config";
    public static final String GET_ALL_DESC = "Gets all group configs.";
    public static final String CREATE_NEW_DESC = "Creates a new group config.";
    public static final String GET_SPECIFIC_DESC = "Gets a specific group config.";
    public static final String UPDATE_DESC = "Updates an existing group config.";
    public static final String PATCH_SPECIFIC_DESC = "Patch a specific group config.";
    public static final String GROUP_BUILD_REQUEST = "List of build config revision to build instead of latest revision.";
    public static final String TRIGGER_DESC = "Builds the build configs in the group config.";
    public static final String GET_BUILD_CONFIGS_DESC = "Gets the build configs for the group config.";
    public static final String ADD_BUILD_CONFIG_DESC = "Adds a build config to the group config.";
    public static final String REMOVE_BUILD_CONFIG_DESC = "Removes a build config from the specified group config.";
    public static final String GET_BUILDS_DESC = "Gets all builds associated with the contained build configs.";
    public static final String GET_ALL_GROUP_BUILDS = "Get all group builds associated with this group config.";

    @Operation(summary="Gets all group configs.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.GroupConfigPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    public Page<GroupConfiguration> getAll(@Valid @BeanParam PageParameters var1);

    @Operation(summary="Creates a new group config.", responses={@ApiResponse(responseCode="201", description="Entity successfully created", content={@Content(schema=@Schema(implementation=GroupConfiguration.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.CREATED)
    public GroupConfiguration createNew(@NotNull GroupConfiguration var1);

    @Operation(summary="Gets a specific group config.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=GroupConfiguration.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}")
    @Consumes(value={"application/json-patch+json"})
    public GroupConfiguration getSpecific(@Parameter(description="ID of the group config") @PathParam(value="id") String var1);

    @Operation(summary="Updates an existing group config.", responses={@ApiResponse(responseCode="204", description="Entity successfully updated"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @PUT
    @Path(value="/{id}")
    public void update(@Parameter(description="ID of the group config") @PathParam(value="id") String var1, @NotNull GroupConfiguration var2);

    @Operation(summary="Patch a specific group config.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=GroupConfiguration.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @PATCH
    @Path(value="/{id}")
    @Consumes(value={"application/json-patch+json"})
    public GroupConfiguration patchSpecific(@Parameter(description="ID of the group config") @PathParam(value="id") String var1, @NotNull GroupConfiguration var2);

    @Operation(summary="Builds the build configs in the group config.", responses={@ApiResponse(responseCode="202", description="Request was accepted for processing", content={@Content(schema=@Schema(implementation=GroupBuild.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.ACCEPTED)
    @Path(value="/{id}/build")
    @Consumes(value={"application/json"})
    public GroupBuild trigger(@Parameter(description="ID of the group config") @PathParam(value="id") String var1, @Valid @BeanParam GroupBuildParameters var2, @Parameter(description="List of build config revision to build instead of latest revision.") GroupBuildRequest var3);

    @Operation(summary="Gets the build configs for the group config.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.BuildConfigPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/build-configs")
    public Page<BuildConfiguration> getBuildConfigs(@Parameter(description="ID of the group config") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2);

    @Operation(summary="Adds a build config to the group config.", responses={@ApiResponse(responseCode="204", description="Success but no content provided"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @Path(value="/{id}/build-configs")
    public void addBuildConfig(@Parameter(description="ID of the group config") @PathParam(value="id") String var1, BuildConfigurationRef var2);

    @Operation(summary="Removes a build config from the specified group config.", responses={@ApiResponse(responseCode="204", description="Success but no content provided"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @DELETE
    @Path(value="/{id}/build-configs/{configId}")
    public void removeBuildConfig(@Parameter(description="ID of the group config") @PathParam(value="id") String var1, @Parameter(description="ID of the build config") @PathParam(value="configId") String var2);

    @Operation(summary="Gets all builds associated with the contained build configs.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.BuildPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/builds")
    public Page<Build> getBuilds(@Parameter(description="ID of the group config") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2, @BeanParam BuildsFilterParameters var3);

    @Operation(summary="Get all group builds associated with this group config.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.GroupBuildPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/group-builds")
    public Page<GroupBuild> getAllGroupBuilds(@Parameter(description="ID of the group config") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2, @BeanParam GroupBuildsFilterParameters var3);
}

