/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.api.endpoints;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.pnc.dto.Artifact;
import org.jboss.pnc.dto.TargetRepository;
import org.jboss.pnc.dto.response.ErrorResponse;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.rest.annotation.RespondWithStatus;
import org.jboss.pnc.rest.api.parameters.PageParameters;
import org.jboss.pnc.rest.api.swagger.response.SwaggerPages;

@Tag(name="Target Repositories")
@Path(value="/target-repositories")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface TargetRepositoryEndpoint {
    public static final String REPO_ID = "The target repository ID";
    public static final String GET_ALL = "Gets all target repositories.";
    public static final String GET_SPECIFIC_DESC = "Gets a specific target repository.";
    public static final String CREATE_NEW_DESC = "Creates a new target repository.";
    public static final String GET_ARTIFACTS = "Gets all artifacts associated with a specific target repository.";

    @Operation(summary="Gets all target repositories.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.TargetRepositoryPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    public Page<TargetRepository> getAll(@Valid @BeanParam PageParameters var1);

    @Operation(summary="Gets a specific target repository.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=TargetRepository.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}")
    public TargetRepository getSpecific(@Parameter(description="The target repository ID") @PathParam(value="id") String var1);

    @Operation(summary="[role:pnc-app-build-user, pnc-app-artifact-user, pnc-users-admin] Creates a new target repository.", responses={@ApiResponse(responseCode="201", description="Entity successfully created", content={@Content(schema=@Schema(implementation=TargetRepository.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.CREATED)
    public TargetRepository createNew(@NotNull TargetRepository var1);

    @Operation(summary="Gets all artifacts associated with a specific target repository.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.ArtifactPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/artifacts")
    public Page<Artifact> getArtifacts(@Parameter(description="The target repository ID") @PathParam(value="id") Integer var1, @Valid @BeanParam PageParameters var2);
}

