package org.jboss.pnc.client;

import java.lang.String;
import java.util.Optional;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.dto.BuildConfiguration;
import org.jboss.pnc.dto.BuildConfigurationRef;
import org.jboss.pnc.dto.GroupBuild;
import org.jboss.pnc.dto.GroupConfiguration;
import org.jboss.pnc.dto.requests.GroupBuildRequest;
import org.jboss.pnc.rest.api.endpoints.GroupConfigurationEndpoint;
import org.jboss.pnc.rest.api.parameters.BuildsFilterParameters;
import org.jboss.pnc.rest.api.parameters.GroupBuildParameters;
import org.jboss.pnc.rest.api.parameters.GroupBuildsFilterParameters;

public class GroupConfigurationClient extends ClientBase<GroupConfigurationEndpoint> {
  public GroupConfigurationClient(Configuration configuration) {
    super(configuration, GroupConfigurationEndpoint.class);
  }

  public RemoteCollection<GroupConfiguration> getAll(Optional<String> sort, Optional<String> query)
      throws RemoteResourceException {
    try {
      PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getAll(pageParameters);}, getRemoteCollectionConfig());
      return pageLoader.getCollection();
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getAll(pageParameters);}, getRemoteCollectionConfig());
          return pageLoader.getCollection();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RemoteCollection<GroupConfiguration> getAll() throws RemoteResourceException {
    try {
      return getAll(Optional.empty(), Optional.empty());
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          return getAll(Optional.empty(), Optional.empty());
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public GroupConfiguration createNew(GroupConfiguration groupConfig) throws
      RemoteResourceException {
    try {
      return getEndpoint().createNew(groupConfig);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          return getEndpoint().createNew(groupConfig);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public GroupConfiguration getSpecific(String id) throws RemoteResourceException {
    try {
      return getEndpoint().getSpecific(id);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          return getEndpoint().getSpecific(id);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public void update(String id, GroupConfiguration groupConfig) throws RemoteResourceException,
      RemoteResourceNotFoundException {
    try {
      getEndpoint().update(id, groupConfig);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          getEndpoint().update(id, groupConfig);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public GroupBuild trigger(String id, GroupBuildParameters buildParams, GroupBuildRequest request)
      throws RemoteResourceException {
    try {
      return getEndpoint().trigger(id, buildParams, request);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          return getEndpoint().trigger(id, buildParams, request);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RemoteCollection<BuildConfiguration> getBuildConfigs(String id, Optional<String> sort,
      Optional<String> query) throws RemoteResourceException {
    try {
      PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getBuildConfigs(id, pageParameters);}, getRemoteCollectionConfig());
      return pageLoader.getCollection();
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getBuildConfigs(id, pageParameters);}, getRemoteCollectionConfig());
          return pageLoader.getCollection();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RemoteCollection<BuildConfiguration> getBuildConfigs(String id) throws
      RemoteResourceException {
    try {
      return getBuildConfigs(id, Optional.empty(), Optional.empty());
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          return getBuildConfigs(id, Optional.empty(), Optional.empty());
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public void addBuildConfig(String id, BuildConfigurationRef buildConfig) throws
      RemoteResourceException, RemoteResourceNotFoundException {
    try {
      getEndpoint().addBuildConfig(id, buildConfig);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          getEndpoint().addBuildConfig(id, buildConfig);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public void removeBuildConfig(String id, String configId) throws RemoteResourceException,
      RemoteResourceNotFoundException {
    try {
      getEndpoint().removeBuildConfig(id, configId);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          getEndpoint().removeBuildConfig(id, configId);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RemoteCollection<Build> getBuilds(String id, BuildsFilterParameters filterParams,
      Optional<String> sort, Optional<String> query) throws RemoteResourceException {
    try {
      PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getBuilds(id, pageParameters, filterParams);}, getRemoteCollectionConfig());
      return pageLoader.getCollection();
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getBuilds(id, pageParameters, filterParams);}, getRemoteCollectionConfig());
          return pageLoader.getCollection();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RemoteCollection<Build> getBuilds(String id, BuildsFilterParameters filterParams) throws
      RemoteResourceException {
    try {
      return getBuilds(id, filterParams, Optional.empty(), Optional.empty());
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          return getBuilds(id, filterParams, Optional.empty(), Optional.empty());
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RemoteCollection<GroupBuild> getAllGroupBuilds(String id,
      GroupBuildsFilterParameters filterParams, Optional<String> sort, Optional<String> query)
      throws RemoteResourceException {
    try {
      PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getAllGroupBuilds(id, pageParameters, filterParams);}, getRemoteCollectionConfig());
      return pageLoader.getCollection();
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getAllGroupBuilds(id, pageParameters, filterParams);}, getRemoteCollectionConfig());
          return pageLoader.getCollection();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RemoteCollection<GroupBuild> getAllGroupBuilds(String id,
      GroupBuildsFilterParameters filterParams) throws RemoteResourceException {
    try {
      return getAllGroupBuilds(id, filterParams, Optional.empty(), Optional.empty());
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          return getAllGroupBuilds(id, filterParams, Optional.empty(), Optional.empty());
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }
}
