package org.jboss.pnc.client;

import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.jboss.pnc.api.dto.ComponentVersion;
import org.jboss.pnc.rest.api.endpoints.VersionEndpoint;

public class VersionClient extends ClientBase<VersionEndpoint> {
  public VersionClient(Configuration configuration) {
    super(configuration, VersionEndpoint.class);
  }

  public ComponentVersion getCurrentVersion() throws RemoteResourceException {
    try {
      return getEndpoint().getCurrentVersion();
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          return getEndpoint().getCurrentVersion();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }
}
