/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.api.endpoints;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.dto.GroupBuild;
import org.jboss.pnc.dto.requests.GroupBuildPushRequest;
import org.jboss.pnc.dto.response.ErrorResponse;
import org.jboss.pnc.dto.response.Graph;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.pncmetrics.rest.TimedMetric;
import org.jboss.pnc.rest.annotation.RespondWithStatus;
import org.jboss.pnc.rest.api.parameters.BuildsFilterParameters;
import org.jboss.pnc.rest.api.parameters.PageParameters;
import org.jboss.pnc.rest.api.swagger.response.SwaggerGraphs;
import org.jboss.pnc.rest.api.swagger.response.SwaggerPages;

@Tag(name="Group Builds")
@Path(value="/group-builds")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface GroupBuildEndpoint {
    public static final String GB_ID = "ID of the group build";
    public static final String GET_ALL_DESC = "Gets all group builds.";
    public static final String GET_SPECIFIC_DESC = "Gets specific group build.";
    public static final String DELETE_DESC = "Delete a specific temporary group build.";
    public static final String DELETE_DESC2 = "Operation is async. Once completed, a callback can be sent with a JSON body containing information about the operation completion using object org.jboss.pnc.dto.DeleteOperationResult";
    public static final String GET_BUILDS_DESC = "Gets the builds associated with this group build.";
    public static final String BREW_PUSH_DESC = "Push all perfomred builds from this group build to Brew.";
    public static final String CANCEL_DESC = "Cancel all builds running in the build group.";
    public static final String GET_DEPENDENCY_GRAPH = "Gets builds dependency graph for a build group.";

    @Operation(summary="Gets all group builds.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.GroupBuildPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @TimedMetric
    public Page<GroupBuild> getAll(@Valid @BeanParam PageParameters var1);

    @Operation(summary="Gets specific group build.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=GroupBuild.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}")
    public GroupBuild getSpecific(@Parameter(description="ID of the group build") @PathParam(value="id") String var1);

    @Operation(summary="Delete a specific temporary group build.", description="Operation is async. Once completed, a callback can be sent with a JSON body containing information about the operation completion using object org.jboss.pnc.dto.DeleteOperationResult", responses={@ApiResponse(responseCode="202", description="Request was accepted for processing"), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @DELETE
    @RespondWithStatus(value=Response.Status.ACCEPTED)
    @Path(value="/{id}")
    public void delete(@Parameter(description="ID of the group build") @PathParam(value="id") String var1, @Parameter(description="Optional Callback URL") @QueryParam(value="callback") String var2);

    @Operation(summary="Gets the builds associated with this group build.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.BuildPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/builds")
    @TimedMetric
    public Page<Build> getBuilds(@Parameter(description="ID of the group build") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2, @BeanParam BuildsFilterParameters var3);

    @Operation(summary="Push all perfomred builds from this group build to Brew.", responses={@ApiResponse(responseCode="202", description="Request was accepted for processing"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.ACCEPTED)
    @Path(value="/{id}/brew-push")
    public void brewPush(@Parameter(description="ID of the group build") @PathParam(value="id") String var1, GroupBuildPushRequest var2);

    @Operation(summary="Cancel all builds running in the build group.", responses={@ApiResponse(responseCode="202", description="Request was accepted for processing"), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.ACCEPTED)
    @Path(value="/{id}/cancel")
    public void cancel(@Parameter(description="ID of the group build") @PathParam(value="id") String var1);

    @Operation(summary="Gets builds dependency graph for a build group.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerGraphs.BuildsGraph.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/dependency-graph")
    @TimedMetric
    public Graph<Build> getDependencyGraph(@Parameter(description="ID of the group build") @PathParam(value="id") String var1);
}

