/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.client;

import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestLoggingFilter
implements ClientRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(RequestLoggingFilter.class);

    public void filter(ClientRequestContext requestContext) throws IOException {
        MultivaluedMap headers = requestContext.getStringHeaders();
        logger.debug("Requesting: {} {} Headers: {}.", new Object[]{requestContext.getMethod(), requestContext.getUri(), RequestLoggingFilter.toString((MultivaluedMap<String, String>)headers)});
    }

    public static String toString(MultivaluedMap<String, String> map) {
        return map.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + entry.getValue()).collect(Collectors.joining("; "));
    }
}

