/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.pnc.client.RemoteCollection;
import org.jboss.pnc.client.RemoteCollectionConfig;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.rest.api.parameters.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRemoteCollection<T>
implements RemoteCollection<T> {
    private final Logger logger = LoggerFactory.getLogger(DefaultRemoteCollection.class);
    private Function<PageParameters, Page<T>> endpoint;
    private RemoteCollectionConfig config;
    protected Page<T> currentPage;

    public DefaultRemoteCollection(Function<PageParameters, Page<T>> endpoint, RemoteCollectionConfig config) {
        this.endpoint = endpoint;
        this.config = config;
        PageParameters intialPageParameters = new PageParameters();
        intialPageParameters.setPageIndex(0);
        intialPageParameters.setPageSize(config.getPageSize());
        this.logger.debug("Loading first page.");
        this.currentPage = endpoint.apply(intialPageParameters);
    }

    @Override
    public int size() {
        return this.currentPage.getTotalHits();
    }

    @Override
    public Iterator<T> iterator() {
        return new RemoteIterator();
    }

    @Override
    public Collection<T> getAll() {
        ArrayList list = new ArrayList();
        this.forEach(list::add);
        return list;
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            action.accept(iterator.next());
        }
    }

    private Page<T> loadNextPage(Function<PageParameters, Page<T>> endpoint, Page<T> currentPage) {
        int newPageIndex = currentPage.getPageIndex() + 1;
        this.logger.debug("Loading new page. Index {}", (Object)newPageIndex);
        PageParameters pageParametersNext = new PageParameters();
        pageParametersNext.setPageSize(currentPage.getPageSize());
        pageParametersNext.setPageIndex(newPageIndex);
        return endpoint.apply(pageParametersNext);
    }

    private class RemoteIterator
    implements Iterator<T> {
        private Iterator<T> iterator;

        public RemoteIterator() {
            this.iterator = DefaultRemoteCollection.this.currentPage.getContent().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.iterator.hasNext()) {
                return true;
            }
            if (DefaultRemoteCollection.this.currentPage.getPageIndex() < DefaultRemoteCollection.this.currentPage.getTotalPages() - 1) {
                DefaultRemoteCollection.this.currentPage = DefaultRemoteCollection.this.loadNextPage(DefaultRemoteCollection.this.endpoint, DefaultRemoteCollection.this.currentPage);
                this.iterator = DefaultRemoteCollection.this.currentPage.getContent().iterator();
                return this.iterator.hasNext();
            }
            return false;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                return this.iterator.next();
            }
            throw new NoSuchElementException();
        }
    }
}

