/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.client;

import java.util.Optional;
import javax.ws.rs.WebApplicationException;
import org.jboss.pnc.client.ClientException;
import org.jboss.pnc.dto.response.ErrorResponse;

public class RemoteResourceException
extends ClientException {
    private final int status;
    private final ErrorResponse response;

    public RemoteResourceException(Throwable cause) {
        super(cause);
        this.status = -1;
        this.response = null;
    }

    public RemoteResourceException(WebApplicationException cause) {
        super((Throwable)cause);
        this.status = cause.getResponse().getStatus();
        this.response = null;
    }

    public RemoteResourceException(ErrorResponse response, WebApplicationException cause) {
        super(response == null ? cause.getMessage() : response.getErrorMessage(), (Exception)cause);
        this.status = cause.getResponse().getStatus();
        this.response = response;
    }

    public RemoteResourceException(String message, int status) {
        super(message + " status: " + status);
        this.status = status;
        this.response = null;
    }

    public Optional<ErrorResponse> getResponse() {
        return Optional.ofNullable(this.response);
    }

    public int getStatus() {
        return this.status;
    }
}

