/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.client;

import java.util.Optional;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.jboss.pnc.client.ClientBase;
import org.jboss.pnc.client.Configuration;
import org.jboss.pnc.client.PageReader;
import org.jboss.pnc.client.RemoteCollection;
import org.jboss.pnc.client.RemoteResourceException;
import org.jboss.pnc.client.RemoteResourceNotFoundException;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.dto.User;
import org.jboss.pnc.rest.api.endpoints.UserEndpoint;
import org.jboss.pnc.rest.api.parameters.BuildsFilterParameters;
import org.jboss.pnc.rest.api.parameters.PageParameters;

public class UserClient
extends ClientBase<UserEndpoint> {
    public UserClient(Configuration configuration) {
        super(configuration, UserEndpoint.class);
    }

    public User getCurrentUser() throws RemoteResourceException {
        try {
            return ((UserEndpoint)this.getEndpoint()).getCurrentUser();
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setTokenSupplier(this.configuration.getBearerTokenSupplier());
                    return ((UserEndpoint)this.getEndpoint()).getCurrentUser();
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public RemoteCollection<Build> getBuilds(String id, BuildsFilterParameters buildsFilter, Optional<String> sort, Optional<String> query) throws RemoteResourceException {
        try {
            PageReader pageLoader = new PageReader(pageParameters -> {
                this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                return ((UserEndpoint)this.getEndpoint()).getBuilds(id, (PageParameters)pageParameters, buildsFilter);
            }, this.getRemoteCollectionConfig());
            return pageLoader.getCollection();
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setTokenSupplier(this.configuration.getBearerTokenSupplier());
                    PageReader pageLoader = new PageReader(pageParameters -> {
                        this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                        return ((UserEndpoint)this.getEndpoint()).getBuilds(id, (PageParameters)pageParameters, buildsFilter);
                    }, this.getRemoteCollectionConfig());
                    return pageLoader.getCollection();
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public RemoteCollection<Build> getBuilds(String id, BuildsFilterParameters buildsFilter) throws RemoteResourceException {
        try {
            return this.getBuilds(id, buildsFilter, Optional.empty(), Optional.empty());
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setTokenSupplier(this.configuration.getBearerTokenSupplier());
                    return this.getBuilds(id, buildsFilter, Optional.empty(), Optional.empty());
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }
}

