package org.jboss.pnc.client;

import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.jboss.pnc.dto.PncStatus;
import org.jboss.pnc.rest.api.endpoints.PncStatusEndpoint;

public class PncStatusClient extends ClientBase<PncStatusEndpoint> {
  public PncStatusClient(Configuration configuration) {
    super(configuration, PncStatusEndpoint.class);
  }

  public void setPncStatus(PncStatus pncStatus) throws RemoteResourceException,
      RemoteResourceNotFoundException {
    try {
      getEndpoint().setPncStatus(pncStatus);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          getEndpoint().setPncStatus(pncStatus);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public PncStatus getPncStatus() throws RemoteResourceException {
    try {
      return getEndpoint().getPncStatus();
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          return getEndpoint().getPncStatus();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }
}
