/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.api.endpoints;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.jboss.pnc.dto.Artifact;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.dto.BuildConfigurationRevision;
import org.jboss.pnc.dto.BuildPushResult;
import org.jboss.pnc.dto.insights.BuildRecordInsights;
import org.jboss.pnc.dto.requests.BuildPushParameters;
import org.jboss.pnc.dto.response.ErrorResponse;
import org.jboss.pnc.dto.response.Graph;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.dto.response.RunningBuildCount;
import org.jboss.pnc.dto.response.SSHCredentials;
import org.jboss.pnc.pncmetrics.rest.TimedMetric;
import org.jboss.pnc.rest.annotation.RespondWithStatus;
import org.jboss.pnc.rest.api.parameters.BuildsFilterParameters;
import org.jboss.pnc.rest.api.parameters.PageParameters;
import org.jboss.pnc.rest.api.swagger.response.SwaggerGraphs;
import org.jboss.pnc.rest.api.swagger.response.SwaggerPages;

@Tag(name="Builds")
@Path(value="/builds")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface BuildEndpoint {
    public static final String B_ID = "ID of the build";
    public static final String BUILD_STATUS = "Status of the build";
    public static final String ARTIFACT_IDS = "List of artifact ids";
    public static final String ATTRIBUTE_KEY = "Attribute key. The key must match '[a-zA-Z_0-9]+'.";
    public static final String ATTRIBUTE_VALUE = "Attribute value";
    public static final String TIMESTAMP_PARAM = "Timestamp using Linux epoch in milliseconds";
    public static final String GET_ALL_DESC = "Gets all builds.";
    public static final String GET_ALL_DESC2 = "Query by attribute: when the attributes are specified only the completed builds are searched. The query format is: attribute=KEY:VALUE&attribute=KEY2:VALUE2 which translates to 'where KEY=VALUE AND KEY2=VALUE2' To search for the records without certain key the key must be prefixed with '!': attribute=!KEY";
    public static final String GET_SPECIFIS_DESC = "Gets specific build.";
    public static final String DELETE_DESC = "Delete a specific temporary build.";
    public static final String DELETE_DESC2 = "Operation is async. Once completed, a callback can be sent with a JSON body containing information about the operation completion using object org.jboss.pnc.dto.DeleteOperationResult";
    public static final String UPDATE_DESC = "Updates an existing build.";
    public static final String GET_BUILT_ARTIFACTS_DESC = "Gets artifacts built in a specific build.";
    public static final String SET_BUILT_ARTIFACTS = "Set built artifacts on the Build. Note that operation replaces existing collection!";
    public static final String CREATE_BUILT_ARTIFACTS_QUALITY_REVISION = "Add a new quality level revision for the built artifacts of this build. Accepted values from standard users are NEW, VERIFIED, TESTED, DEPRECATED. Users with pnc-app-artifact-user, pnc-app-build-user, pnc-users-admin role can also specify BLACKLISTED and DELETED quality levels.";
    public static final String ARTIFACT_QUALITY = "Quality level of the artifact.";
    public static final String ARTIFACT_QUALITY_REASON = "The reason for adding a new quality level for this artifact.";
    public static final String GET_DEPENDENCY_ARTIFACTS_DESC = "Gets dependency artifacts for specific build.";
    public static final String SET_DEPENDANT_ARTIFACTS_DESC = "Set dependent artifacts on the Build. Note that operation replaces existing collection!";
    public static final String GET_INTERNAL_SCM_ARCHIVE_DESC = "Redirects to the SCM archive link";
    public static final String ADD_ATTRIBUTE_DESC = "Add attribute to a specific build.";
    public static final String REMOVE_ATTRIBUTE_DESC = "Remove attribute from a specific build.";
    public static final String GET_PUSH_RESULT_DESC = "Get Brew push result for specific build.";
    public static final String PUSH_DESC = "Push build to Brew.";
    public static final String CANCEL_PUSH_DESC = "Cancels push of build to Brew.";
    public static final String COMPLETE_PUSH_DESC = "Notifies that the Brew push finished.";
    public static final String GET_BUILD_CONFIG_REVISION = "Gets the build config revision for specific build.";
    public static final String CANCEL_DESC = "Cancel running build.";
    public static final String GET_DEPENDENCY_GRAPH = "Gets dependency graph for a build.";
    public static final String GET_ALIGN_LOGS_DESC = "Gets alignment logs for specific build.";
    public static final String GET_BUILD_LOGS_DESC = "Gets build logs for specific build. This endpoint serves as a redirect.";
    public static final String GET_SSH_CREDENTIALS_DESC = "Gets ssh credentials to log into the build pod.";
    public static final String GET_SSH_CREDENTIALS_DESC2 = "This GET requests require authentication";
    public static final String LOG_SEARCH = "Log search string";
    public static final String GET_ALL_BY_STATUS_AND_LOG_CONTAINING_DESC = "Gets the Builds by given status and with specific string in the build logs.";
    public static final String GET_RUNNING_COUNT_DESC = "Get count of running builds in their stages: running, waiting for dependencies, or enqueued";
    public static final String GET_ALL_INDEPENDENT_TEMPORARY_BUILDS_OLDER_THAN_TIMESTAMP_DESC = "Returns a collection of temporary builds older than timestamp without implicit dependants (no Build depends on these)";
    public static final String GET_ALL_BUILD_RECORD_INSIGHTS_NEWER_THAN_TIMESTAMP_DESC = "Returns a collection of build record insights created or updated after timestamp";

    @Operation(summary="Gets all builds.", description="Query by attribute: when the attributes are specified only the completed builds are searched. The query format is: attribute=KEY:VALUE&attribute=KEY2:VALUE2 which translates to 'where KEY=VALUE AND KEY2=VALUE2' To search for the records without certain key the key must be prefixed with '!': attribute=!KEY", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.BuildPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @TimedMetric
    public Page<Build> getAll(@Valid @BeanParam PageParameters var1, @BeanParam BuildsFilterParameters var2, @QueryParam(value="attribute") List<String> var3);

    @Operation(summary="Gets specific build.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=Build.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}")
    public Build getSpecific(@Parameter(description="ID of the build") @PathParam(value="id") String var1);

    @Operation(summary="[role:pnc-app-build-delete, pnc-app-build-user, pnc-users-admin] Delete a specific temporary build.", description="Operation is async. Once completed, a callback can be sent with a JSON body containing information about the operation completion using object org.jboss.pnc.dto.DeleteOperationResult", tags={"Internal"}, responses={@ApiResponse(responseCode="202", description="Request was accepted for processing"), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @DELETE
    @RespondWithStatus(value=Response.Status.ACCEPTED)
    @Path(value="/{id}")
    public void delete(@Parameter(description="ID of the build") @PathParam(value="id") String var1, @Parameter(description="Optional Callback URL") @QueryParam(value="callback") String var2);

    @Operation(summary="[role:pnc-app-build-user, pnc-users-admin] Updates an existing build.", tags={"Internal"}, responses={@ApiResponse(responseCode="204", description="Entity successfully updated"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @PUT
    @Path(value="/{id}")
    public void update(@Parameter(description="ID of the build") @PathParam(value="id") String var1, @NotNull Build var2);

    @Operation(summary="Gets artifacts built in a specific build.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.ArtifactPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/artifacts/built")
    @TimedMetric
    public Page<Artifact> getBuiltArtifacts(@Parameter(description="ID of the build") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2);

    @Operation(summary="[role:pnc-app-build-user, pnc-users-admin] Set built artifacts on the Build. Note that operation replaces existing collection!", tags={"Internal"}, responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.ArtifactPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @PUT
    @Path(value="/{id}/artifacts/built")
    public void setBuiltArtifacts(@Parameter(description="ID of the build") @PathParam(value="id") String var1, @Parameter(description="List of artifact ids") List<String> var2);

    @Operation(summary="Add a new quality level revision for the built artifacts of this build. Accepted values from standard users are NEW, VERIFIED, TESTED, DEPRECATED. Users with pnc-app-artifact-user, pnc-app-build-user, pnc-users-admin role can also specify BLACKLISTED and DELETED quality levels.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.ArtifactPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @Path(value="/{id}/artifacts/built/quality")
    public void createBuiltArtifactsQualityLevelRevisions(@Parameter(description="ID of the build") @PathParam(value="id") String var1, @Parameter(description="Quality level of the artifact.", required=true) @QueryParam(value="quality") String var2, @Parameter(description="The reason for adding a new quality level for this artifact.", required=true) @QueryParam(value="reason") String var3);

    @Operation(summary="Gets dependency artifacts for specific build.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.ArtifactPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/artifacts/dependencies")
    @TimedMetric
    public Page<Artifact> getDependencyArtifacts(@Parameter(description="ID of the build") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2);

    @Operation(summary="[role:pnc-app-build-user, pnc-users-admin] Set dependent artifacts on the Build. Note that operation replaces existing collection!", tags={"Internal"}, responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.ArtifactPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @PUT
    @Path(value="/{id}/artifacts/dependencies")
    public void setDependentArtifacts(@Parameter(description="ID of the build") @PathParam(value="id") String var1, @Parameter(description="List of artifact ids") List<String> var2);

    @Operation(summary="Redirects to the SCM archive link", responses={@ApiResponse(responseCode="302", description="Redirected to resource"), @ApiResponse(responseCode="404", description="Can not find specified result")})
    @GET
    @Path(value="/{id}/scm-archive")
    public Response getInternalScmArchiveLink(@Parameter(description="ID of the build") @PathParam(value="id") String var1);

    @Operation(summary="Add attribute to a specific build.", responses={@ApiResponse(responseCode="201", description="Entity successfully created"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.CREATED)
    @Path(value="/{id}/attributes")
    public void addAttribute(@Parameter(description="ID of the build") @PathParam(value="id") String var1, @Parameter(description="Attribute key. The key must match '[a-zA-Z_0-9]+'.", required=true) @QueryParam(value="key") String var2, @Parameter(description="Attribute value", required=true) @QueryParam(value="value") String var3);

    @Operation(summary="Remove attribute from a specific build.", responses={@ApiResponse(responseCode="204", description="Entity deleted"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @DELETE
    @Path(value="/{id}/attributes")
    public void removeAttribute(@Parameter(description="ID of the build") @PathParam(value="id") String var1, @Parameter(description="Attribute key. The key must match '[a-zA-Z_0-9]+'.", required=true) @QueryParam(value="key") String var2);

    @Operation(summary="Get Brew push result for specific build.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=BuildPushResult.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/brew-push")
    @TimedMetric
    public BuildPushResult getPushResult(@Parameter(description="ID of the build") @PathParam(value="id") String var1);

    @Operation(summary="Push build to Brew.", responses={@ApiResponse(responseCode="202", description="Request was accepted for processing", content={@Content(schema=@Schema(implementation=BuildPushResult.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Build contains artifacts of insufficient quality", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.ACCEPTED)
    @Path(value="/{id}/brew-push")
    public BuildPushResult push(@Parameter(description="ID of the build") @PathParam(value="id") String var1, @Valid BuildPushParameters var2);

    @Operation(summary="Cancels push of build to Brew.", responses={@ApiResponse(responseCode="202", description="Request was accepted for processing"), @ApiResponse(responseCode="404", description="Can not find any Brew push in progress."), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @DELETE
    @RespondWithStatus(value=Response.Status.ACCEPTED)
    @Path(value="/{id}/brew-push")
    public void cancelPush(@Parameter(description="ID of the build") @PathParam(value="id") String var1);

    @Operation(summary="Notifies that the Brew push finished.", tags={"Internal"}, responses={@ApiResponse(responseCode="201", description="Entity successfully created", content={@Content(schema=@Schema(implementation=BuildPushResult.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.CREATED)
    @Path(value="/{id}/brew-push/complete")
    public BuildPushResult completePush(@Parameter(description="ID of the build") @PathParam(value="id") String var1, BuildPushResult var2);

    @Operation(summary="Gets the build config revision for specific build.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=BuildConfigurationRevision.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/build-config-revision")
    public BuildConfigurationRevision getBuildConfigRevision(@Parameter(description="ID of the build") @PathParam(value="id") String var1);

    @Operation(summary="Cancel running build.", responses={@ApiResponse(responseCode="202", description="Request was accepted for processing"), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.ACCEPTED)
    @Path(value="/{id}/cancel")
    public void cancel(@Parameter(description="ID of the build") @PathParam(value="id") String var1);

    @Operation(summary="Gets dependency graph for a build.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerGraphs.BuildsGraph.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/dependency-graph")
    @TimedMetric
    public Graph<Build> getDependencyGraph(@Parameter(description="ID of the build") @PathParam(value="id") String var1);

    @Operation(summary="Gets alignment logs for specific build.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/logs/align")
    @TimedMetric
    @Produces(value={"text/plain"})
    public StreamingOutput getAlignLogs(@Parameter(description="ID of the build") @PathParam(value="id") String var1);

    @Operation(summary="Gets build logs for specific build. This endpoint serves as a redirect.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/logs/build")
    @TimedMetric
    @Produces(value={"text/plain"})
    public StreamingOutput getBuildLogs(@Parameter(description="ID of the build") @PathParam(value="id") String var1);

    @Operation(summary="Gets ssh credentials to log into the build pod.", description="This GET requests require authentication", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SSHCredentials.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/ssh-credentials/{id}")
    public SSHCredentials getSshCredentials(@Parameter(description="ID of the build") @PathParam(value="id") String var1);

    @Operation(summary="Get count of running builds in their stages: running, waiting for dependencies, or enqueued", description="Get count of running builds in their stages: running, waiting for dependencies, or enqueued", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=RunningBuildCount.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/count")
    @TimedMetric
    public RunningBuildCount getCount();

    @Operation(summary="Returns a collection of temporary builds older than timestamp without implicit dependants (no Build depends on these)", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.BuildPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/independent-temporary-older-than-timestamp")
    @TimedMetric
    public Page<Build> getAllIndependentTempBuildsOlderThanTimestamp(@Valid @BeanParam PageParameters var1, @Parameter(description="Timestamp using Linux epoch in milliseconds") @QueryParam(value="timestamp") long var2);

    @Operation(summary="Returns a collection of build record insights created or updated after timestamp", tags={"Internal"}, responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.BuildRecordInsightsPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/build-insights-newer-than-timestamp")
    @TimedMetric
    public Page<BuildRecordInsights> getAllBuildRecordInsightsNewerThanTimestamp(@Parameter(description="Number of entries that should be included in a page. Maximum page size is 200.") @QueryParam(value="pageSize") int var1, @Parameter(description="Index of the page to return. Index starts with 0.") @QueryParam(value="pageIndex") int var2, @Parameter(description="Timestamp using Linux epoch in milliseconds") @QueryParam(value="timestamp") long var3);
}

