/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.api.endpoints;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.pnc.dto.Environment;
import org.jboss.pnc.dto.requests.EnvironmentDeprecationRequest;
import org.jboss.pnc.dto.response.ErrorResponse;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.rest.annotation.RespondWithStatus;
import org.jboss.pnc.rest.api.parameters.PageParameters;
import org.jboss.pnc.rest.api.swagger.response.SwaggerPages;

@Tag(name="Environments")
@Path(value="/environments")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface EnvironmentEndpoint {
    public static final String E_ID = "ID of the environment";
    public static final String GET_ALL_DESC = "Gets all environments.";
    public static final String CREATE_NEW_DESC = "Creates a new environment.";
    public static final String DEPRECATE_DESC = "Marks environment as deprecated.";
    public static final String GET_SPECIFIC_DESC = "Gets a specific environment.";

    @Operation(summary="Gets all environments.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.BuildEnvironmentPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    public Page<Environment> getAll(@Valid @BeanParam PageParameters var1);

    @Operation(summary="Gets a specific environment.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=Environment.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}")
    public Environment getSpecific(@Parameter(description="ID of the environment") @PathParam(value="id") String var1);

    @Operation(summary="[role:pnc-app-environment-user, pnc-users-admin] Creates a new environment.", responses={@ApiResponse(responseCode="201", description="Entity successfully created", content={@Content(schema=@Schema(implementation=Environment.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.CREATED)
    public Environment createNew(@NotNull Environment var1);

    @Operation(summary="[role:pnc-app-environment-user, pnc-users-admin] Marks environment as deprecated.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=Environment.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @Path(value="/{id}/deprecate")
    public Environment deprecate(@Parameter(description="ID of the environment") @PathParam(value="id") String var1, @Valid EnvironmentDeprecationRequest var2);
}

