/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.api.endpoints;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jboss.pnc.dto.response.Banner;
import org.jboss.pnc.dto.response.ErrorResponse;

@Tag(name="Internal")
@Path(value="/generic-setting")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface GenericSettingEndpoint {
    public static final String GET_ANNOUNCEMENT_BANNER_DESC = "Get announcement banner";
    public static final String BANNER_TEXT = "Announcement Banner text";
    public static final String SET_ANNOUNCEMENT_BANNER_DESC = "Set announcement banner. Needs to be admin";
    public static final String GET_PNC_VERSION_DESC = "Get PNC System version";
    public static final String PNC_VERSION = "Current PNC System Version";
    public static final String SET_PNC_VERSION_DESC = "Set current PNC System Version. Needs to be admin";
    public static final String IS_IN_MAINTENANCE_MODE_DESC = "Get status of maintenance mode";
    public static final String IS_USER_ALLOWED_TO_TRIGGER_BUILDS_DESC = "Provides information whether the current user is allowed to trigger builds (pnc-users-admin are always allowed, other users only if maintenance mode is off)";
    public static final String MAINTENANCE_REASON = "Reason to activate Maintenance Mode";
    public static final String ACTIVATE_MAINTENANCE_MODE_DESC = "Activate maintenance mode.";
    public static final String DEACTIVATE_MAINTENANCE_MODE_DESC = "Deactivate maintenance mode. needs to be admin";

    @Operation(summary="Get announcement banner", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=Banner.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="announcement-banner")
    @Deprecated(forRemoval=true, since="2.7.0")
    public Banner getAnnouncementBanner();

    @Operation(summary="Set announcement banner. Needs to be admin", responses={@ApiResponse(responseCode="204", description="Entity successfully updated"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @Path(value="announcement-banner")
    @Deprecated(forRemoval=true, since="2.7.0")
    public void setAnnouncementBanner(@Parameter(description="Announcement Banner text", required=true) String var1);

    @Operation(summary="Get PNC System version", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=Banner.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="pnc-version")
    @Deprecated(forRemoval=true, since="2.7.0")
    public String getPNCVersion();

    @Operation(summary="Set current PNC System Version. Needs to be admin", responses={@ApiResponse(responseCode="204", description="Entity successfully updated"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @Path(value="pnc-version")
    @Deprecated(forRemoval=true, since="2.7.0")
    public void setPNCVersion(@Parameter(description="Current PNC System Version", required=true) String var1);

    @Operation(summary="Get status of maintenance mode", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="in-maintenance-mode")
    @Deprecated(forRemoval=true, since="2.7.0")
    public Boolean isInMaintenanceMode();

    @Operation(summary="Provides information whether the current user is allowed to trigger builds (pnc-users-admin are always allowed, other users only if maintenance mode is off)", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="is-user-allowed-to-trigger-builds")
    public Boolean isCurrentUserAllowedToTriggerBuilds();

    @Operation(summary="[role:pnc-users-admin] Activate maintenance mode.", responses={@ApiResponse(responseCode="204", description="Entity successfully updated"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @Path(value="activate-maintenance-mode")
    @Deprecated(forRemoval=true, since="2.7.0")
    public void activateMaintenanceMode(@Parameter(description="Reason to activate Maintenance Mode", required=true) String var1);

    @Operation(summary="[role:pnc-users-admin] Deactivate maintenance mode. needs to be admin", responses={@ApiResponse(responseCode="204", description="Entity successfully updated"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @Path(value="deactivate-maintenance-mode")
    @Deprecated(forRemoval=true, since="2.7.0")
    public void deactivateMaintenanceMode();
}

