/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.api.parameters;

import io.swagger.v3.oas.annotations.Parameter;
import javax.validation.constraints.Max;
import javax.validation.constraints.PositiveOrZero;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.QueryParam;

public class PaginationParameters {
    @Parameter(description="Index of the page to return. Index starts with 0.")
    @QueryParam(value="pageIndex")
    @DefaultValue(value="0")
    @PositiveOrZero
    protected int pageIndex;
    @Parameter(description="Number of entries that should be included in a page. Maximum page size is 200.")
    @QueryParam(value="pageSize")
    @DefaultValue(value="50")
    @PositiveOrZero
    @Max(value=200L)
    protected @PositiveOrZero @Max(value=200L) int pageSize;

    public int getPageIndex() {
        return this.pageIndex;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaginationParameters)) {
            return false;
        }
        PaginationParameters other = (PaginationParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageIndex() != other.getPageIndex()) {
            return false;
        }
        return this.getPageSize() == other.getPageSize();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaginationParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageIndex();
        result = result * 59 + this.getPageSize();
        return result;
    }

    public String toString() {
        return "PaginationParameters(pageIndex=" + this.getPageIndex() + ", pageSize=" + this.getPageSize() + ")";
    }
}

