/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.client;

import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.WebApplicationException;
import org.jboss.pnc.client.ClientBase;
import org.jboss.pnc.client.Configuration;
import org.jboss.pnc.client.RemoteResourceException;
import org.jboss.pnc.client.RemoteResourceNotFoundException;
import org.jboss.pnc.dto.BuildPushReport;
import org.jboss.pnc.rest.api.endpoints.BuildPushesEndpoint;

public class BuildPushesClient
extends ClientBase<BuildPushesEndpoint> {
    public BuildPushesClient(Configuration configuration) {
        super(configuration, BuildPushesEndpoint.class);
    }

    public BuildPushReport getPushReport(String operationId) throws RemoteResourceException {
        try {
            return ((BuildPushesEndpoint)this.getEndpoint()).getPushReport(operationId);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setTokenSupplier(this.configuration.getBearerTokenSupplier());
                    return ((BuildPushesEndpoint)this.getEndpoint()).getPushReport(operationId);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }
}

