/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.client;

import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.WebApplicationException;
import java.util.Optional;
import org.jboss.pnc.client.ClientBase;
import org.jboss.pnc.client.Configuration;
import org.jboss.pnc.client.RemoteResourceException;
import org.jboss.pnc.client.RemoteResourceNotFoundException;
import org.jboss.pnc.dto.response.Banner;
import org.jboss.pnc.rest.api.endpoints.GenericSettingEndpoint;

public class GenericSettingClient
extends ClientBase<GenericSettingEndpoint> {
    public GenericSettingClient(Configuration configuration) {
        super(configuration, GenericSettingEndpoint.class);
    }

    public Banner getAnnouncementBanner() throws RemoteResourceException {
        try {
            return ((GenericSettingEndpoint)this.getEndpoint()).getAnnouncementBanner();
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setTokenSupplier(this.configuration.getBearerTokenSupplier());
                    return ((GenericSettingEndpoint)this.getEndpoint()).getAnnouncementBanner();
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public void setAnnouncementBanner(String banner) throws RemoteResourceException, RemoteResourceNotFoundException {
        try {
            ((GenericSettingEndpoint)this.getEndpoint()).setAnnouncementBanner(banner);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setTokenSupplier(this.configuration.getBearerTokenSupplier());
                    ((GenericSettingEndpoint)this.getEndpoint()).setAnnouncementBanner(banner);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public Optional<String> getPNCVersion() throws RemoteResourceException {
        try {
            return Optional.ofNullable(((GenericSettingEndpoint)this.getEndpoint()).getPNCVersion());
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setTokenSupplier(this.configuration.getBearerTokenSupplier());
                    return Optional.ofNullable(((GenericSettingEndpoint)this.getEndpoint()).getPNCVersion());
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public void setPNCVersion(String version) throws RemoteResourceException, RemoteResourceNotFoundException {
        try {
            ((GenericSettingEndpoint)this.getEndpoint()).setPNCVersion(version);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setTokenSupplier(this.configuration.getBearerTokenSupplier());
                    ((GenericSettingEndpoint)this.getEndpoint()).setPNCVersion(version);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public Boolean isInMaintenanceMode() throws RemoteResourceException {
        try {
            return ((GenericSettingEndpoint)this.getEndpoint()).isInMaintenanceMode();
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setTokenSupplier(this.configuration.getBearerTokenSupplier());
                    return ((GenericSettingEndpoint)this.getEndpoint()).isInMaintenanceMode();
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public Boolean isCurrentUserAllowedToTriggerBuilds() throws RemoteResourceException {
        try {
            return ((GenericSettingEndpoint)this.getEndpoint()).isCurrentUserAllowedToTriggerBuilds();
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setTokenSupplier(this.configuration.getBearerTokenSupplier());
                    return ((GenericSettingEndpoint)this.getEndpoint()).isCurrentUserAllowedToTriggerBuilds();
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public void activateMaintenanceMode(String reason) throws RemoteResourceException, RemoteResourceNotFoundException {
        try {
            ((GenericSettingEndpoint)this.getEndpoint()).activateMaintenanceMode(reason);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setTokenSupplier(this.configuration.getBearerTokenSupplier());
                    ((GenericSettingEndpoint)this.getEndpoint()).activateMaintenanceMode(reason);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public void deactivateMaintenanceMode() throws RemoteResourceException, RemoteResourceNotFoundException {
        try {
            ((GenericSettingEndpoint)this.getEndpoint()).deactivateMaintenanceMode();
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setTokenSupplier(this.configuration.getBearerTokenSupplier());
                    ((GenericSettingEndpoint)this.getEndpoint()).deactivateMaintenanceMode();
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }
}

