/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.api.endpoints;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.dto.User;
import org.jboss.pnc.dto.response.ErrorResponse;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.rest.api.parameters.BuildsFilterParameters;
import org.jboss.pnc.rest.api.parameters.PageParameters;
import org.jboss.pnc.rest.api.swagger.response.SwaggerPages;

@Tag(name="Users")
@Path(value="/users")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface UserEndpoint {
    public static final String U_ID = "ID of the user";
    public static final String GET_CURRENT_USER_DESC = "Gets logged user.";
    public static final String GET_BUILDS = "Gets all builds triggered by specific user.";

    @Operation(summary="Gets logged user.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=User.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/current")
    public User getCurrentUser();

    @Operation(summary="Gets all builds triggered by specific user.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.BuildPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/builds")
    public Page<Build> getBuilds(@Parameter(description="ID of the user") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2, @BeanParam BuildsFilterParameters var3);
}

