package org.jboss.pnc.client;

import java.lang.String;
import java.util.Optional;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.dto.User;
import org.jboss.pnc.rest.api.endpoints.UserEndpoint;
import org.jboss.pnc.rest.api.parameters.BuildsFilterParameters;

public class UserClient extends ClientBase<UserEndpoint> {
  public UserClient(Configuration configuration) {
    super(configuration, UserEndpoint.class);
  }

  public User getCurrentUser() throws RemoteResourceException {
    try {
      return getEndpoint().getCurrentUser();
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          return getEndpoint().getCurrentUser();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RemoteCollection<Build> getBuilds(String id, BuildsFilterParameters buildsFilter,
      Optional<String> sort, Optional<String> query) throws RemoteResourceException {
    try {
      PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getBuilds(id, pageParameters, buildsFilter);}, getRemoteCollectionConfig());
      return pageLoader.getCollection();
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getBuilds(id, pageParameters, buildsFilter);}, getRemoteCollectionConfig());
          return pageLoader.getCollection();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RemoteCollection<Build> getBuilds(String id, BuildsFilterParameters buildsFilter) throws
      RemoteResourceException {
    try {
      return getBuilds(id, buildsFilter, Optional.empty(), Optional.empty());
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          return getBuilds(id, buildsFilter, Optional.empty(), Optional.empty());
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }
}
