/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.api.endpoints;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.pnc.dto.BuildConfiguration;
import org.jboss.pnc.dto.GroupConfiguration;
import org.jboss.pnc.dto.ProductMilestone;
import org.jboss.pnc.dto.ProductRelease;
import org.jboss.pnc.dto.ProductVersion;
import org.jboss.pnc.dto.response.ErrorResponse;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.dto.response.statistics.ProductMilestoneArtifactQualityStatistics;
import org.jboss.pnc.dto.response.statistics.ProductMilestoneRepositoryTypeStatistics;
import org.jboss.pnc.dto.response.statistics.ProductVersionStatistics;
import org.jboss.pnc.rest.annotation.RespondWithStatus;
import org.jboss.pnc.rest.api.parameters.PageParameters;
import org.jboss.pnc.rest.api.swagger.response.SwaggerPages;

@Tag(name="Product Versions")
@Path(value="/product-versions")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface ProductVersionEndpoint {
    public static final String PV_ID = "ID of the product version";
    public static final String CREATE_NEW_DESC = "Creates a new product version.";
    public static final String GET_SPECIFIC_DESC = "Gets a specific product version.";
    public static final String UPDATE_DESC = "Updates an existing product version.";
    public static final String PATCH_SPECIFIC_DESC = "Patch an existing product version.";
    public static final String GET_BUILD_CONFIGS_DESC = "Gets all build configs in a specific product version.";
    public static final String GET_GROUP_CONFIGS = "Gets group configs associated with a specific product version.";
    public static final String GET_MILESTONES = "Gets all product milestones of a specific product version.";
    public static final String GET_RELEASES = "Gets all product releases of a specific product version.";
    public static final String GET_PV_STATISTICS = "Gets statistics about produced and delivered artifacts from this product version.";
    public static final String GET_ARTIFACT_QUALITIES_STATISTICS = "Gets statistics about proportion of quality of delivered artifacts in this product version.";
    public static final String GET_REPOSITORY_TYPES_STATISTICS = "Gets statistics about proportion of repository types of delivered artifacts in this product version.";

    @Operation(summary="Creates a new product version.", responses={@ApiResponse(responseCode="201", description="Entity successfully created", content={@Content(schema=@Schema(implementation=ProductVersion.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.CREATED)
    public ProductVersion createNew(@NotNull ProductVersion var1);

    @Operation(summary="Gets a specific product version.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=ProductVersion.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}")
    @Consumes(value={"application/json-patch+json"})
    public ProductVersion getSpecific(@Parameter(description="ID of the product version") @PathParam(value="id") String var1);

    @Operation(summary="Updates an existing product version.", responses={@ApiResponse(responseCode="204", description="Entity successfully updated"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @PUT
    @Path(value="/{id}")
    public void update(@Parameter(description="ID of the product version") @PathParam(value="id") String var1, @NotNull ProductVersion var2);

    @Operation(summary="Patch an existing product version.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=ProductVersion.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @PATCH
    @Path(value="/{id}")
    @Consumes(value={"application/json-patch+json"})
    public ProductVersion patchSpecific(@Parameter(description="ID of the product version") @PathParam(value="id") String var1, @NotNull ProductVersion var2);

    @Operation(summary="Gets all build configs in a specific product version.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.BuildConfigPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/build-configs")
    public Page<BuildConfiguration> getBuildConfigs(@Parameter(description="ID of the product version") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2);

    @Operation(summary="Gets group configs associated with a specific product version.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.GroupConfigPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/group-configs")
    public Page<GroupConfiguration> getGroupConfigs(@Parameter(description="ID of the product version") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2);

    @Operation(summary="Gets all product milestones of a specific product version.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.ProductMilestonePage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/milestones")
    public Page<ProductMilestone> getMilestones(@Parameter(description="ID of the product version") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2);

    @Operation(summary="Gets all product releases of a specific product version.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.ProductReleasePage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/releases")
    public Page<ProductRelease> getReleases(@Parameter(description="ID of the product version") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2);

    @Operation(summary="Gets statistics about produced and delivered artifacts from this product version.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=ProductVersionStatistics.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/statistics")
    public ProductVersionStatistics getStatistics(@Parameter(description="ID of the product version") @PathParam(value="id") String var1);

    @Operation(summary="Gets statistics about proportion of quality of delivered artifacts in this product version.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.ProductVersionArtifactQualityStatisticsPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/artifact-quality-statistics")
    public Page<ProductMilestoneArtifactQualityStatistics> getArtifactQualitiesStatistics(@Parameter(description="ID of the product version") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2);

    @Operation(summary="Gets statistics about proportion of repository types of delivered artifacts in this product version.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.ProductVersionRepositoryTypeStatisticsPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/repository-type-statistics")
    public Page<ProductMilestoneRepositoryTypeStatistics> getRepositoryTypesStatistics(@Parameter(description="ID of the product version") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2);
}

