/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.client;

import jakarta.ws.rs.Path;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Optional;
import org.jboss.pnc.client.ApacheHttpClient43EngineWithRetry;
import org.jboss.pnc.client.BasicAuthentication;
import org.jboss.pnc.client.BearerAuthentication;
import org.jboss.pnc.client.Configuration;
import org.jboss.pnc.client.MdcToHeadersFilter;
import org.jboss.pnc.client.RemoteCollectionConfig;
import org.jboss.pnc.client.RemoteResourceException;
import org.jboss.pnc.client.RequestLoggingFilter;
import org.jboss.pnc.client.ResteasyJackson2ProviderWithDateISO8601;
import org.jboss.pnc.client.patch.PatchBase;
import org.jboss.pnc.client.patch.PatchBuilderException;
import org.jboss.pnc.dto.response.ErrorResponse;
import org.jboss.pnc.rest.api.parameters.PageParameters;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ProxyBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientBase<T>
implements Closeable {
    private Logger logger = LoggerFactory.getLogger(ClientBase.class);
    protected final String BASE_PATH = "/pnc-rest";
    protected final String BASE_REST_PATH = "/pnc-rest/v2";
    protected final Client client;
    protected final WebTarget target;
    protected T proxy;
    protected Configuration configuration;
    protected Class<T> iface;
    protected BearerAuthentication bearerAuthentication;

    protected ClientBase(Configuration configuration, Class<T> iface) {
        this.iface = iface;
        ApacheHttpClient43EngineWithRetry engine = new ApacheHttpClient43EngineWithRetry();
        engine.setFollowRedirects(true);
        this.configuration = configuration;
        ResteasyClientBuilder clientBuilder = (ResteasyClientBuilder)ClientBuilder.newBuilder();
        this.client = clientBuilder.httpEngine((ClientHttpEngine)engine).build();
        this.client.register(ResteasyJackson2ProviderWithDateISO8601.class);
        this.client.register((Object)new MdcToHeadersFilter(configuration.getMdcToHeadersMappings()));
        this.client.register(RequestLoggingFilter.class);
        this.target = this.client.target(configuration.getProtocol() + "://" + configuration.getHost() + (String)(configuration.getPort() == null ? "" : ":" + configuration.getPort()) + "/pnc-rest/v2");
        Configuration.BasicAuth basicAuth = configuration.getBasicAuth();
        if (basicAuth != null) {
            this.target.register((Object)new BasicAuthentication(basicAuth.getUsername(), basicAuth.getPassword()));
        } else if (configuration.getBearerTokenSupplier() != null) {
            this.bearerAuthentication = new BearerAuthentication(configuration.getBearerTokenSupplier());
            this.target.register((Object)this.bearerAuthentication);
        } else {
            String bearerToken = configuration.getBearerToken();
            if (bearerToken != null && !bearerToken.isEmpty()) {
                this.bearerAuthentication = new BearerAuthentication(() -> bearerToken);
                this.target.register((Object)this.bearerAuthentication);
            }
        }
        this.proxy = ProxyBuilder.builder(iface, (WebTarget)this.target).build();
    }

    protected T getEndpoint() {
        return this.proxy;
    }

    RemoteCollectionConfig getRemoteCollectionConfig() {
        int pageSize = this.configuration.getPageSize();
        if (pageSize < 1) {
            pageSize = 100;
        }
        return new RemoteCollectionConfig(pageSize);
    }

    protected void setSortAndQuery(PageParameters pageParameters, Optional<String> sort, Optional<String> q) {
        sort.ifPresent(pageParameters::setSort);
        q.ifPresent(pageParameters::setQ);
    }

    public <S> S patch(String id, String jsonPatch, Class<S> clazz) throws RemoteResourceException {
        Path path = this.iface.getAnnotation(Path.class);
        WebTarget patchTarget = !path.value().equals("") && !path.value().equals("/") ? this.target.path(path.value() + "/" + id) : this.target.path(id);
        this.logger.debug("Json patch: {}", (Object)jsonPatch);
        try {
            Object result = patchTarget.request().build("PATCH", Entity.entity((Object)jsonPatch, (String)"application/json-patch+json")).invoke(clazz);
            return (S)result;
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public InputStream getInputStream(String methodPath, String id) {
        Path path = this.iface.getAnnotation(Path.class);
        String interfacePath = path.value();
        WebTarget webTarget = this.target.path(interfacePath + methodPath).resolveTemplate("id", (Object)id);
        return (InputStream)webTarget.request().build("GET").invoke(InputStream.class);
    }

    public <S> S patch(String id, PatchBase patchBase) throws PatchBuilderException, RemoteResourceException {
        String jsonPatch = patchBase.getJsonPatch();
        try {
            return this.patch(id, jsonPatch, patchBase.getClazz());
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    protected ErrorResponse readErrorResponse(WebApplicationException ex) {
        Response response = ex.getResponse();
        if (response.hasEntity()) {
            try {
                return (ErrorResponse)response.readEntity(ErrorResponse.class);
            }
            catch (ProcessingException | IllegalStateException e) {
                this.logger.debug("Can't map response to ErrorResponse.", e);
            }
            catch (RuntimeException e) {
                this.logger.warn("Unexpected exception when trying to read ErrorResponse.", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void close() {
        this.client.close();
    }
}

