/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.client;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import org.jboss.pnc.common.logging.MDCUtils;

public class Configuration {
    private final String host;
    private final Integer port;
    private final BasicAuth basicAuth;
    @Deprecated
    private final String bearerToken;
    private final Supplier<String> bearerTokenSupplier;
    private final String protocol;
    private final int pageSize;
    private Map<String, String> mdcToHeadersMappings;

    public String getWSProtocol() {
        if (this.protocol == null) {
            return "ws";
        }
        switch (this.protocol) {
            case "https": {
                return "wss";
            }
        }
        return "ws";
    }

    @Generated
    public static ConfigurationBuilder builder() {
        return new ConfigurationBuilder();
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public BasicAuth getBasicAuth() {
        return this.basicAuth;
    }

    @Deprecated
    @Generated
    public String getBearerToken() {
        return this.bearerToken;
    }

    @Generated
    public Supplier<String> getBearerTokenSupplier() {
        return this.bearerTokenSupplier;
    }

    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Generated
    public int getPageSize() {
        return this.pageSize;
    }

    @Generated
    public Map<String, String> getMdcToHeadersMappings() {
        return this.mdcToHeadersMappings;
    }

    @Generated
    public void setMdcToHeadersMappings(Map<String, String> mdcToHeadersMappings) {
        this.mdcToHeadersMappings = mdcToHeadersMappings;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        BasicAuth this$basicAuth = this.getBasicAuth();
        BasicAuth other$basicAuth = other.getBasicAuth();
        if (this$basicAuth == null ? other$basicAuth != null : !this$basicAuth.equals(other$basicAuth)) {
            return false;
        }
        String this$bearerToken = this.getBearerToken();
        String other$bearerToken = other.getBearerToken();
        if (this$bearerToken == null ? other$bearerToken != null : !this$bearerToken.equals(other$bearerToken)) {
            return false;
        }
        Supplier<String> this$bearerTokenSupplier = this.getBearerTokenSupplier();
        Supplier<String> other$bearerTokenSupplier = other.getBearerTokenSupplier();
        if (this$bearerTokenSupplier == null ? other$bearerTokenSupplier != null : !this$bearerTokenSupplier.equals(other$bearerTokenSupplier)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        Map<String, String> this$mdcToHeadersMappings = this.getMdcToHeadersMappings();
        Map<String, String> other$mdcToHeadersMappings = other.getMdcToHeadersMappings();
        return !(this$mdcToHeadersMappings == null ? other$mdcToHeadersMappings != null : !((Object)this$mdcToHeadersMappings).equals(other$mdcToHeadersMappings));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Configuration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageSize();
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        BasicAuth $basicAuth = this.getBasicAuth();
        result = result * 59 + ($basicAuth == null ? 43 : $basicAuth.hashCode());
        String $bearerToken = this.getBearerToken();
        result = result * 59 + ($bearerToken == null ? 43 : $bearerToken.hashCode());
        Supplier<String> $bearerTokenSupplier = this.getBearerTokenSupplier();
        result = result * 59 + ($bearerTokenSupplier == null ? 43 : $bearerTokenSupplier.hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        Map<String, String> $mdcToHeadersMappings = this.getMdcToHeadersMappings();
        result = result * 59 + ($mdcToHeadersMappings == null ? 43 : ((Object)$mdcToHeadersMappings).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Configuration(host=" + this.getHost() + ", port=" + this.getPort() + ", basicAuth=" + this.getBasicAuth() + ", bearerToken=" + this.getBearerToken() + ", bearerTokenSupplier=" + this.getBearerTokenSupplier() + ", protocol=" + this.getProtocol() + ", pageSize=" + this.getPageSize() + ", mdcToHeadersMappings=" + this.getMdcToHeadersMappings() + ")";
    }

    @Generated
    public Configuration(String host, Integer port, BasicAuth basicAuth, String bearerToken, Supplier<String> bearerTokenSupplier, String protocol, int pageSize, Map<String, String> mdcToHeadersMappings) {
        this.host = host;
        this.port = port;
        this.basicAuth = basicAuth;
        this.bearerToken = bearerToken;
        this.bearerTokenSupplier = bearerTokenSupplier;
        this.protocol = protocol;
        this.pageSize = pageSize;
        this.mdcToHeadersMappings = mdcToHeadersMappings;
    }

    public static final class ConfigurationBuilder {
        @Generated
        private String host;
        @Generated
        private Integer port;
        @Generated
        private BasicAuth basicAuth;
        @Generated
        private String bearerToken;
        @Generated
        private Supplier<String> bearerTokenSupplier;
        @Generated
        private String protocol;
        @Generated
        private int pageSize;
        private Map<String, String> mdcToHeadersMappings = new HashMap<String, String>();

        public ConfigurationBuilder addDefaultMdcToHeadersMappings() {
            this.mdcToHeadersMappings = new HashMap<String, String>(MDCUtils.HEADER_KEY_MAPPING);
            return this;
        }

        @Generated
        ConfigurationBuilder() {
        }

        @Generated
        public ConfigurationBuilder host(String host) {
            this.host = host;
            return this;
        }

        @Generated
        public ConfigurationBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        @Generated
        public ConfigurationBuilder basicAuth(BasicAuth basicAuth) {
            this.basicAuth = basicAuth;
            return this;
        }

        @Deprecated
        @Generated
        public ConfigurationBuilder bearerToken(String bearerToken) {
            this.bearerToken = bearerToken;
            return this;
        }

        @Generated
        public ConfigurationBuilder bearerTokenSupplier(Supplier<String> bearerTokenSupplier) {
            this.bearerTokenSupplier = bearerTokenSupplier;
            return this;
        }

        @Generated
        public ConfigurationBuilder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Generated
        public ConfigurationBuilder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Generated
        public ConfigurationBuilder mdcToHeadersMappings(Map<String, String> mdcToHeadersMappings) {
            this.mdcToHeadersMappings = mdcToHeadersMappings;
            return this;
        }

        @Generated
        public Configuration build() {
            return new Configuration(this.host, this.port, this.basicAuth, this.bearerToken, this.bearerTokenSupplier, this.protocol, this.pageSize, this.mdcToHeadersMappings);
        }

        @Generated
        public String toString() {
            return "Configuration.ConfigurationBuilder(host=" + this.host + ", port=" + this.port + ", basicAuth=" + this.basicAuth + ", bearerToken=" + this.bearerToken + ", bearerTokenSupplier=" + this.bearerTokenSupplier + ", protocol=" + this.protocol + ", pageSize=" + this.pageSize + ", mdcToHeadersMappings=" + this.mdcToHeadersMappings + ")";
        }
    }

    public static class BasicAuth {
        private String username;
        private String password;

        public BasicAuth(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getBase64Credentials() {
            return Base64.getEncoder().encodeToString((this.username + ":" + this.password).getBytes());
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }
    }
}

