/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.client;

import java.util.Set;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.jboss.pnc.client.ClientBase;
import org.jboss.pnc.client.Configuration;
import org.jboss.pnc.client.RemoteResourceException;
import org.jboss.pnc.client.RemoteResourceNotFoundException;
import org.jboss.pnc.dto.ProductRelease;
import org.jboss.pnc.enums.SupportLevel;
import org.jboss.pnc.rest.api.endpoints.ProductReleaseEndpoint;

public class ProductReleaseClient
extends ClientBase<ProductReleaseEndpoint> {
    public ProductReleaseClient(Configuration configuration) {
        super(configuration, ProductReleaseEndpoint.class);
    }

    public ProductRelease createNew(ProductRelease productRelease) throws RemoteResourceException {
        try {
            return ((ProductReleaseEndpoint)this.getEndpoint()).createNew(productRelease);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setTokenSupplier(this.configuration.getBearerTokenSupplier());
                    return ((ProductReleaseEndpoint)this.getEndpoint()).createNew(productRelease);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public ProductRelease getSpecific(String id) throws RemoteResourceException {
        try {
            return ((ProductReleaseEndpoint)this.getEndpoint()).getSpecific(id);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setTokenSupplier(this.configuration.getBearerTokenSupplier());
                    return ((ProductReleaseEndpoint)this.getEndpoint()).getSpecific(id);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public void update(String id, ProductRelease productRelease) throws RemoteResourceException, RemoteResourceNotFoundException {
        try {
            ((ProductReleaseEndpoint)this.getEndpoint()).update(id, productRelease);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setTokenSupplier(this.configuration.getBearerTokenSupplier());
                    ((ProductReleaseEndpoint)this.getEndpoint()).update(id, productRelease);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public Set<SupportLevel> getSupportLevels() throws RemoteResourceException {
        try {
            return ((ProductReleaseEndpoint)this.getEndpoint()).getSupportLevels();
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setTokenSupplier(this.configuration.getBearerTokenSupplier());
                    return ((ProductReleaseEndpoint)this.getEndpoint()).getSupportLevels();
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }
}

