/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.api.endpoints;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.pnc.dto.response.ErrorResponse;
import org.jboss.pnc.pncmetrics.rest.TimedMetric;

@Tag(name="Cache statistics")
@Path(value="/cache")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface CacheEndpoint {
    public static final String GET_GENERIC_STATS_DESC = "Get general statistics related to Hibernate.";
    public static final String GET_SLC_ENTITIES_STATS_DESC = "Get statistics of all entities in second-level cache.";
    public static final String GET_SLC_REGIONS_STATS_DESC = "Get statistics of all cache region names in second-level cache.";
    public static final String GET_SLC_COLLECTIONS_STATS_DESC = "Get statistics of all collections in second-level cache.";
    public static final String CLEAR_CACHE_DESC = "Delete all content from second level cache. Needs to be admin";

    @Operation(summary="Get general statistics related to Hibernate.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=MapOfMaps.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/statistics")
    @TimedMetric
    public Response getGenericStats();

    @Operation(summary="Get statistics of all entities in second-level cache.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=MapOfMaps.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/entity-statistics")
    @TimedMetric
    public Response getSecondLevelCacheEntitiesStats();

    @Operation(summary="Get statistics of all cache region names in second-level cache.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=MapOfMaps.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/region-statistics")
    @TimedMetric
    public Response getSecondLevelCacheRegionsStats();

    @Operation(summary="Get statistics of all collections in second-level cache.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=MapOfMaps.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/collection-statistics")
    @TimedMetric
    public Response getSecondLevelCacheCollectionsStats();

    @Operation(summary="Delete all content from second level cache. Needs to be admin", tags={"Internal"}, responses={@ApiResponse(responseCode="200", description="Success with results"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @DELETE
    public Response clearCache();

    public static interface MapOfMaps
    extends Map<String, Map<String, Object>> {
    }
}

