/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.api.endpoints;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jboss.pnc.dto.DeliverableAnalyzerLabelEntry;
import org.jboss.pnc.dto.DeliverableAnalyzerReport;
import org.jboss.pnc.dto.requests.labels.DeliverableAnalyzerReportLabelRequest;
import org.jboss.pnc.dto.response.AnalyzedArtifact;
import org.jboss.pnc.dto.response.ErrorResponse;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.pncmetrics.rest.TimedMetric;
import org.jboss.pnc.rest.api.parameters.PageParameters;
import org.jboss.pnc.rest.api.swagger.response.SwaggerPages;

@Tag(name="Deliverable Analysis")
@Path(value="/deliverable-analyses")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface DeliverableAnalyzerReportEndpoint {
    public static final String DEL_AN_ID = "Id of the Deliverable Analysis Report";
    public static final String GET_ALL_DESC = "Gets all deliverable analyzer reports.";
    public static final String GET_SPECIFIC_DESC = "Gets specific deliverable analyzer report.";
    public static final String GET_ANALYZED_ARTIFACTS = "Gets analyzed artifacts of this deliverable analysis report";
    public static final String ADD_DEL_AN_REPORT_LABEL = "Adds label to this deliverable analyzer report";
    public static final String REMOVE_DEL_AN_REPORT_LABEL = "Removes label from this deliverable analyzer report";
    public static final String GET_DEL_AN_REPORT_LABEL_HISTORY = "Gets the label history of this deliverable analyzer report";

    @Operation(summary="Gets all deliverable analyzer reports.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.DeliverableAnalyzerReportPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @TimedMetric
    public Page<DeliverableAnalyzerReport> getAll(@Valid @BeanParam PageParameters var1);

    @Operation(summary="Gets specific deliverable analyzer report.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=DeliverableAnalyzerReport.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}")
    public DeliverableAnalyzerReport getSpecific(@Parameter(description="Id of the Deliverable Analysis Report") @PathParam(value="id") String var1);

    @Operation(summary="Gets analyzed artifacts of this deliverable analysis report", responses={@ApiResponse(description="Success with results", responseCode="200", content={@Content(schema=@Schema(implementation=SwaggerPages.AnalyzedArtifactPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Path(value="/{id}/analyzed-artifacts")
    @GET
    public Page<AnalyzedArtifact> getAnalyzedArtifacts(@Parameter(description="Id of the Deliverable Analysis Report") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2);

    @Operation(summary="Adds label to this deliverable analyzer report", responses={@ApiResponse(responseCode="201", description="Entity successfully created"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Path(value="/{id}/add-label")
    @POST
    public void addLabel(@Parameter(description="Id of the Deliverable Analysis Report") @PathParam(value="id") String var1, @Valid DeliverableAnalyzerReportLabelRequest var2);

    @Operation(summary="Removes label from this deliverable analyzer report", responses={@ApiResponse(responseCode="204", description="Entity deleted"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Path(value="/{id}/remove-label")
    @POST
    public void removeLabel(@Parameter(description="Id of the Deliverable Analysis Report") @PathParam(value="id") String var1, @Valid DeliverableAnalyzerReportLabelRequest var2);

    @Operation(summary="Gets the label history of this deliverable analyzer report", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.DeliverableAnalyzerLabelEntryPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Path(value="/{id}/labels-history")
    @GET
    public Page<DeliverableAnalyzerLabelEntry> getLabelHistory(@Parameter(description="Id of the Deliverable Analysis Report") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2);
}

