package org.jboss.pnc.client;

import java.lang.String;
import java.util.Optional;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.jboss.pnc.dto.BuildConfiguration;
import org.jboss.pnc.dto.SCMRepository;
import org.jboss.pnc.dto.requests.CreateAndSyncSCMRequest;
import org.jboss.pnc.dto.response.RepositoryCreationResponse;
import org.jboss.pnc.rest.api.endpoints.SCMRepositoryEndpoint;

public class SCMRepositoryClient extends ClientBase<SCMRepositoryEndpoint> {
  public SCMRepositoryClient(Configuration configuration) {
    super(configuration, SCMRepositoryEndpoint.class);
  }

  public RemoteCollection<SCMRepository> getAll(String matchUrl, String searchUrl,
      Optional<String> sort, Optional<String> query) throws RemoteResourceException {
    try {
      PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getAll(pageParameters, matchUrl, searchUrl);}, getRemoteCollectionConfig());
      return pageLoader.getCollection();
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getAll(pageParameters, matchUrl, searchUrl);}, getRemoteCollectionConfig());
          return pageLoader.getCollection();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RemoteCollection<SCMRepository> getAll(String matchUrl, String searchUrl) throws
      RemoteResourceException {
    try {
      return getAll(matchUrl, searchUrl, Optional.empty(), Optional.empty());
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          return getAll(matchUrl, searchUrl, Optional.empty(), Optional.empty());
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public SCMRepository getSpecific(String id) throws RemoteResourceException {
    try {
      return getEndpoint().getSpecific(id);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          return getEndpoint().getSpecific(id);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public void update(String id, SCMRepository scmRepository) throws RemoteResourceException,
      RemoteResourceNotFoundException {
    try {
      getEndpoint().update(id, scmRepository);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          getEndpoint().update(id, scmRepository);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RepositoryCreationResponse createNew(CreateAndSyncSCMRequest request) throws
      RemoteResourceException {
    try {
      return getEndpoint().createNew(request);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          return getEndpoint().createNew(request);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RemoteCollection<BuildConfiguration> getBuildConfigs(String id, Optional<String> sort,
      Optional<String> query) throws RemoteResourceException {
    try {
      PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getBuildConfigs(id, pageParameters);}, getRemoteCollectionConfig());
      return pageLoader.getCollection();
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getBuildConfigs(id, pageParameters);}, getRemoteCollectionConfig());
          return pageLoader.getCollection();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RemoteCollection<BuildConfiguration> getBuildConfigs(String id) throws
      RemoteResourceException {
    try {
      return getBuildConfigs(id, Optional.empty(), Optional.empty());
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          return getBuildConfigs(id, Optional.empty(), Optional.empty());
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }
}
