package org.jboss.pnc.client;

import java.lang.String;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.jboss.pnc.dto.BuildPushReport;
import org.jboss.pnc.rest.api.endpoints.BuildPushesEndpoint;

public class BuildPushesClient extends ClientBase<BuildPushesEndpoint> {
  public BuildPushesClient(Configuration configuration) {
    super(configuration, BuildPushesEndpoint.class);
  }

  public BuildPushReport getPushReport(String operationId) throws RemoteResourceException {
    try {
      return getEndpoint().getPushReport(operationId);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          return getEndpoint().getPushReport(operationId);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }
}
