/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.api.endpoints;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.jboss.pnc.dto.Artifact;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.dto.BuildPushOperation;
import org.jboss.pnc.dto.DeliverableAnalyzerOperation;
import org.jboss.pnc.dto.ProductMilestone;
import org.jboss.pnc.dto.requests.DeliverablesAnalysisRequest;
import org.jboss.pnc.dto.requests.MilestoneCloseRequest;
import org.jboss.pnc.dto.requests.validation.VersionValidationRequest;
import org.jboss.pnc.dto.response.DeliveredArtifactInMilestones;
import org.jboss.pnc.dto.response.ErrorResponse;
import org.jboss.pnc.dto.response.Graph;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.dto.response.ValidationResponse;
import org.jboss.pnc.dto.response.statistics.ProductMilestoneStatistics;
import org.jboss.pnc.pncmetrics.rest.TimedMetric;
import org.jboss.pnc.rest.annotation.RespondWithStatus;
import org.jboss.pnc.rest.api.parameters.BuildsFilterParameters;
import org.jboss.pnc.rest.api.parameters.PageParameters;
import org.jboss.pnc.rest.api.swagger.response.SwaggerPages;

@Tag(name="Product Milestones")
@Path(value="/product-milestones")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface ProductMilestoneEndpoint {
    public static final String PM_ID = "ID of the product milestone";
    public static final String CREATE_NEW_DESC = "Creates a new product milestone.";
    public static final String GET_SPECIFIC_DESC = "Gets a specific product milestone.";
    public static final String UPDATE_DESC = "Updates an existing product milestone.";
    public static final String PATCH_SPECIFIC_DESC = "Patch an existing product milestone.";
    public static final String GET_BUILDS_DESC = "Gets builds performed during a product milestone cycle.";
    public static final String CLOSE_MILESTONE_DESC = "Close a product milestone.";
    public static final String CLOSE_MILESTONE_CANCEL_DESC = "Cancel product milestone close process.";
    public static final String GET_PUSH_OPERATIONS_DESC = "Get build push operations for specified milestone.";
    public static final String LATEST_OPERATION_DESC = "Should return only latest operation for each build?";
    public static final String GET_DELIVERABLES_DESC = "Gets artifacts delivered in this milestone.";
    public static final String GET_ALL_DELIVERABLE_ANALYZER_OPERATIONS_FILTERED_DESC = "Gets all deliverable analyzer operations executed for this milestone.";
    public static final String GET_STATISTICS = "Gets statistics about produced and delivered artifacts from this milestone.";
    public static final String VALIDATE_VERSION = "Validate product milestone version.";
    public static final String DELIVERABLES_ANALYSIS_DESC = "Send a request to start analysis of deliverables. This endpoint creates an asynchronous task.";
    public static final String GET_DELIVERED_ARTIFACTS_COMPARISON = "Gets Artifacts Delivered in at least two of the Milestones and their versions.";
    public static final String GET_MILESTONES_INTERCONNECTION_GRAPH = "Finds Milestones sharing Delivered Artifacts with a requested Milestones, and so for those Milestones to create a graph. Maximum depth limit is 5.";
    public static final String GET_DELIVERED_ARTIFACTS_SHARED_IN_MILESTONES = "Fetches Artifacts delivered in both of the Milestones.";

    @Operation(summary="Creates a new product milestone.", responses={@ApiResponse(responseCode="201", description="Entity successfully created", content={@Content(schema=@Schema(implementation=ProductMilestone.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.CREATED)
    public ProductMilestone createNew(@NotNull ProductMilestone var1);

    @Operation(summary="Gets a specific product milestone.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=ProductMilestone.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}")
    @Consumes(value={"application/json-patch+json"})
    public ProductMilestone getSpecific(@Parameter(description="ID of the product milestone") @PathParam(value="id") String var1);

    @Operation(summary="Updates an existing product milestone.", responses={@ApiResponse(responseCode="204", description="Entity successfully updated"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @PUT
    @Path(value="/{id}")
    public void update(@Parameter(description="ID of the product milestone") @PathParam(value="id") String var1, @NotNull ProductMilestone var2);

    @Operation(summary="Patch an existing product milestone.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=ProductMilestone.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @PATCH
    @Path(value="/{id}")
    @Consumes(value={"application/json-patch+json"})
    public ProductMilestone patchSpecific(@Parameter(description="ID of the product milestone") @PathParam(value="id") String var1, @NotNull ProductMilestone var2);

    @Operation(summary="Gets builds performed during a product milestone cycle.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.BuildPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/builds")
    public Page<Build> getBuilds(@Parameter(description="ID of the product milestone") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2, @BeanParam BuildsFilterParameters var3);

    @Operation(summary="Close a product milestone.", responses={@ApiResponse(responseCode="202", description="Request was accepted for processing"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.ACCEPTED)
    @Path(value="/{id}/close")
    public void closeMilestone(@Parameter(description="ID of the product milestone") @PathParam(value="id") String var1, @Valid MilestoneCloseRequest var2);

    @Operation(summary="Cancel product milestone close process.", responses={@ApiResponse(responseCode="202", description="Request was accepted for processing"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @DELETE
    @RespondWithStatus(value=Response.Status.ACCEPTED)
    @Path(value="/{id}/close")
    public void cancelMilestoneClose(@Parameter(description="ID of the product milestone") @PathParam(value="id") String var1);

    @Operation(summary="Get build push operations for specified milestone.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.BuildPushOperationPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="{id}/build-push-operations")
    @TimedMetric
    public Page<BuildPushOperation> getPushOperations(@Parameter(description="ID of the product milestone") @PathParam(value="id") String var1, @Parameter(description="Should return only latest operation for each build?") @QueryParam(value="latest") @DefaultValue(value="false") boolean var2, @Valid @BeanParam PageParameters var3);

    @Operation(summary="Gets artifacts delivered in this milestone.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.ArtifactPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/delivered-artifacts")
    public Page<Artifact> getDeliveredArtifacts(@Parameter(description="ID of the product milestone") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2);

    @Operation(summary="Gets all deliverable analyzer operations executed for this milestone.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.DeliverableAnalyzerOperationPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/deliverables-analyzer-operations")
    public Page<DeliverableAnalyzerOperation> getAllDeliverableAnalyzerOperations(@Parameter(description="ID of the product milestone") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2);

    @Operation(summary="Gets statistics about produced and delivered artifacts from this milestone.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=ProductMilestoneStatistics.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="{id}/statistics")
    public ProductMilestoneStatistics getStatistics(@Parameter(description="ID of the product milestone") @PathParam(value="id") String var1);

    @Operation(summary="Validate product milestone version.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=ValidationResponse.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @Path(value="/validate-version")
    public ValidationResponse validateVersion(@Valid VersionValidationRequest var1);

    @Operation(summary="Send a request to start analysis of deliverables. This endpoint creates an asynchronous task.", responses={@ApiResponse(responseCode="202", description="Request was accepted for processing"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.ACCEPTED)
    @Path(value="/{id}/analyze-deliverables")
    public DeliverableAnalyzerOperation analyzeDeliverables(@Parameter(description="ID of the product milestone") @PathParam(value="id") String var1, @Valid DeliverablesAnalysisRequest var2);

    @Operation(summary="Gets Artifacts Delivered in at least two of the Milestones and their versions.", responses={@ApiResponse(responseCode="200", description="Success with results"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/comparisons/delivered-artifacts")
    public List<DeliveredArtifactInMilestones> compareArtifactVersionsDeliveredInMilestones(@NotEmpty @QueryParam(value="milestoneIds") List<String> var1);

    @Operation(summary="Finds Milestones sharing Delivered Artifacts with a requested Milestones, and so for those Milestones to create a graph. Maximum depth limit is 5.", responses={@ApiResponse(responseCode="200", description="Success with results"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/interconnection-graph")
    public Graph<ProductMilestone> getMilestonesSharingDeliveredArtifactsGraph(@Parameter(description="ID of the product milestone") @PathParam(value="id") String var1, @QueryParam(value="depthLimit") @Min(value=0L) @Max(value=5L) @DefaultValue(value="5") @Min(value=0L) @Max(value=5L) Integer var2);

    @Operation(summary="Fetches Artifacts delivered in both of the Milestones.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.ArtifactPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/delivered-artifacts/shared")
    public Page<Artifact> getDeliveredArtifactsSharedInMilestones(@Valid @BeanParam PageParameters var1, @Parameter(description="ID of the product milestone") @NotBlank @QueryParam(value="milestone1") String var2, @Parameter(description="ID of the product milestone") @NotBlank @QueryParam(value="milestone2") String var3);
}

