package org.jboss.pnc.client;

import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.jboss.pnc.dto.Artifact;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.dto.BuildPushOperation;
import org.jboss.pnc.dto.DeliverableAnalyzerOperation;
import org.jboss.pnc.dto.ProductMilestone;
import org.jboss.pnc.dto.requests.DeliverablesAnalysisRequest;
import org.jboss.pnc.dto.requests.MilestoneCloseRequest;
import org.jboss.pnc.dto.requests.validation.VersionValidationRequest;
import org.jboss.pnc.dto.response.DeliveredArtifactInMilestones;
import org.jboss.pnc.dto.response.Graph;
import org.jboss.pnc.dto.response.ValidationResponse;
import org.jboss.pnc.dto.response.statistics.ProductMilestoneStatistics;
import org.jboss.pnc.rest.api.endpoints.ProductMilestoneEndpoint;
import org.jboss.pnc.rest.api.parameters.BuildsFilterParameters;

public class ProductMilestoneClient extends ClientBase<ProductMilestoneEndpoint> {
  public ProductMilestoneClient(Configuration configuration) {
    super(configuration, ProductMilestoneEndpoint.class);
  }

  public ProductMilestone createNew(ProductMilestone productMilestone) throws
      RemoteResourceException {
    try {
      return getEndpoint().createNew(productMilestone);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          return getEndpoint().createNew(productMilestone);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public ProductMilestone getSpecific(String id) throws RemoteResourceException {
    try {
      return getEndpoint().getSpecific(id);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          return getEndpoint().getSpecific(id);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public void update(String id, ProductMilestone productMilestone) throws RemoteResourceException,
      RemoteResourceNotFoundException {
    try {
      getEndpoint().update(id, productMilestone);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          getEndpoint().update(id, productMilestone);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RemoteCollection<Build> getBuilds(String id, BuildsFilterParameters buildsFilter,
      Optional<String> sort, Optional<String> query) throws RemoteResourceException {
    try {
      PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getBuilds(id, pageParameters, buildsFilter);}, getRemoteCollectionConfig());
      return pageLoader.getCollection();
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getBuilds(id, pageParameters, buildsFilter);}, getRemoteCollectionConfig());
          return pageLoader.getCollection();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RemoteCollection<Build> getBuilds(String id, BuildsFilterParameters buildsFilter) throws
      RemoteResourceException {
    try {
      return getBuilds(id, buildsFilter, Optional.empty(), Optional.empty());
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          return getBuilds(id, buildsFilter, Optional.empty(), Optional.empty());
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public void closeMilestone(String id, MilestoneCloseRequest closeRequest) throws
      RemoteResourceException, RemoteResourceNotFoundException {
    try {
      getEndpoint().closeMilestone(id, closeRequest);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          getEndpoint().closeMilestone(id, closeRequest);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public void cancelMilestoneClose(String id) throws RemoteResourceException,
      RemoteResourceNotFoundException {
    try {
      getEndpoint().cancelMilestoneClose(id);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          getEndpoint().cancelMilestoneClose(id);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RemoteCollection<BuildPushOperation> getPushOperations(String id, boolean latest,
      Optional<String> sort, Optional<String> query) throws RemoteResourceException {
    try {
      PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getPushOperations(id, latest, pageParameters);}, getRemoteCollectionConfig());
      return pageLoader.getCollection();
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getPushOperations(id, latest, pageParameters);}, getRemoteCollectionConfig());
          return pageLoader.getCollection();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RemoteCollection<BuildPushOperation> getPushOperations(String id, boolean latest) throws
      RemoteResourceException {
    try {
      return getPushOperations(id, latest, Optional.empty(), Optional.empty());
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          return getPushOperations(id, latest, Optional.empty(), Optional.empty());
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RemoteCollection<Artifact> getDeliveredArtifacts(String id, Optional<String> sort,
      Optional<String> query) throws RemoteResourceException {
    try {
      PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getDeliveredArtifacts(id, pageParameters);}, getRemoteCollectionConfig());
      return pageLoader.getCollection();
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getDeliveredArtifacts(id, pageParameters);}, getRemoteCollectionConfig());
          return pageLoader.getCollection();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RemoteCollection<Artifact> getDeliveredArtifacts(String id) throws
      RemoteResourceException {
    try {
      return getDeliveredArtifacts(id, Optional.empty(), Optional.empty());
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          return getDeliveredArtifacts(id, Optional.empty(), Optional.empty());
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RemoteCollection<DeliverableAnalyzerOperation> getAllDeliverableAnalyzerOperations(
      String id, Optional<String> sort, Optional<String> query) throws RemoteResourceException {
    try {
      PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getAllDeliverableAnalyzerOperations(id, pageParameters);}, getRemoteCollectionConfig());
      return pageLoader.getCollection();
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getAllDeliverableAnalyzerOperations(id, pageParameters);}, getRemoteCollectionConfig());
          return pageLoader.getCollection();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RemoteCollection<DeliverableAnalyzerOperation> getAllDeliverableAnalyzerOperations(
      String id) throws RemoteResourceException {
    try {
      return getAllDeliverableAnalyzerOperations(id, Optional.empty(), Optional.empty());
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          return getAllDeliverableAnalyzerOperations(id, Optional.empty(), Optional.empty());
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public ProductMilestoneStatistics getStatistics(String id) throws RemoteResourceException {
    try {
      return getEndpoint().getStatistics(id);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          return getEndpoint().getStatistics(id);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public ValidationResponse validateVersion(VersionValidationRequest productMilestone) throws
      RemoteResourceException {
    try {
      return getEndpoint().validateVersion(productMilestone);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          return getEndpoint().validateVersion(productMilestone);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public DeliverableAnalyzerOperation analyzeDeliverables(String id,
      DeliverablesAnalysisRequest request) throws RemoteResourceException {
    try {
      return getEndpoint().analyzeDeliverables(id, request);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          return getEndpoint().analyzeDeliverables(id, request);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public List<DeliveredArtifactInMilestones> compareArtifactVersionsDeliveredInMilestones(
      List<String> milestoneIds) throws RemoteResourceException {
    try {
      return getEndpoint().compareArtifactVersionsDeliveredInMilestones(milestoneIds);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          return getEndpoint().compareArtifactVersionsDeliveredInMilestones(milestoneIds);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public Graph<ProductMilestone> getMilestonesSharingDeliveredArtifactsGraph(String milestoneId,
      Integer depthLimit) throws RemoteResourceException {
    try {
      return getEndpoint().getMilestonesSharingDeliveredArtifactsGraph(milestoneId, depthLimit);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          return getEndpoint().getMilestonesSharingDeliveredArtifactsGraph(milestoneId, depthLimit);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RemoteCollection<Artifact> getDeliveredArtifactsSharedInMilestones(String milestone1Id,
      String milestone2Id, Optional<String> sort, Optional<String> query) throws
      RemoteResourceException {
    try {
      PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getDeliveredArtifactsSharedInMilestones(pageParameters, milestone1Id, milestone2Id);}, getRemoteCollectionConfig());
      return pageLoader.getCollection();
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          PageReader pageLoader = new PageReader<>((pageParameters) -> { setSortAndQuery(pageParameters, sort, query); return getEndpoint().getDeliveredArtifactsSharedInMilestones(pageParameters, milestone1Id, milestone2Id);}, getRemoteCollectionConfig());
          return pageLoader.getCollection();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public RemoteCollection<Artifact> getDeliveredArtifactsSharedInMilestones(String milestone1Id,
      String milestone2Id) throws RemoteResourceException {
    try {
      return getDeliveredArtifactsSharedInMilestones(milestone1Id, milestone2Id, Optional.empty(), Optional.empty());
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setTokenSupplier(configuration.getBearerTokenSupplier());
          return getDeliveredArtifactsSharedInMilestones(milestone1Id, milestone2Id, Optional.empty(), Optional.empty());
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }
}
