/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.api.parameters;

import io.swagger.v3.oas.annotations.Parameter;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.QueryParam;
import lombok.Generated;
import org.jboss.pnc.api.enums.AlignmentPreference;
import org.jboss.pnc.enums.RebuildMode;
import org.jboss.pnc.rest.validation.BuildParametersConstraint;

@BuildParametersConstraint
public class BuildParameters {
    @Parameter(description="Is it a temporary build or a standard build?")
    @QueryParam(value="temporaryBuild")
    @DefaultValue(value="false")
    boolean temporaryBuild;
    @Parameter(description="What should varant rebuild?")
    @QueryParam(value="rebuildMode")
    @DefaultValue(value="IMPLICIT_DEPENDENCY_CHECK")
    RebuildMode rebuildMode;
    @Parameter(description="Should we build also dependencies of this Build Config?")
    @QueryParam(value="buildDependencies")
    @DefaultValue(value="true")
    boolean buildDependencies;
    @Parameter(description="Should we keep the build container running, if the build fails?")
    @QueryParam(value="keepPodOnFailure")
    @DefaultValue(value="false")
    boolean keepPodOnFailure;
    @Parameter(description="This feature was disabled. Setting this value has no effect on the build.")
    @QueryParam(value="timestampAlignment")
    @DefaultValue(value="false")
    boolean timestampAlignment;
    @Parameter(description="Defines temporary build dependency alignment preferences. Default: PREFER_TEMPORARY.")
    @QueryParam(value="alignmentPreference")
    AlignmentPreference alignmentPreference;

    public AlignmentPreference getAlignmentPreference() {
        if (this.alignmentPreference == null && this.isTemporaryBuild()) {
            return AlignmentPreference.PREFER_TEMPORARY;
        }
        return this.alignmentPreference;
    }

    @Generated
    public BuildParameters() {
    }

    @Generated
    public boolean isTemporaryBuild() {
        return this.temporaryBuild;
    }

    @Generated
    public RebuildMode getRebuildMode() {
        return this.rebuildMode;
    }

    @Generated
    public boolean isBuildDependencies() {
        return this.buildDependencies;
    }

    @Generated
    public boolean isKeepPodOnFailure() {
        return this.keepPodOnFailure;
    }

    @Generated
    public boolean isTimestampAlignment() {
        return this.timestampAlignment;
    }

    @Generated
    public void setTemporaryBuild(boolean temporaryBuild) {
        this.temporaryBuild = temporaryBuild;
    }

    @Generated
    public void setRebuildMode(RebuildMode rebuildMode) {
        this.rebuildMode = rebuildMode;
    }

    @Generated
    public void setBuildDependencies(boolean buildDependencies) {
        this.buildDependencies = buildDependencies;
    }

    @Generated
    public void setKeepPodOnFailure(boolean keepPodOnFailure) {
        this.keepPodOnFailure = keepPodOnFailure;
    }

    @Generated
    public void setTimestampAlignment(boolean timestampAlignment) {
        this.timestampAlignment = timestampAlignment;
    }

    @Generated
    public void setAlignmentPreference(AlignmentPreference alignmentPreference) {
        this.alignmentPreference = alignmentPreference;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildParameters)) {
            return false;
        }
        BuildParameters other = (BuildParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTemporaryBuild() != other.isTemporaryBuild()) {
            return false;
        }
        if (this.isBuildDependencies() != other.isBuildDependencies()) {
            return false;
        }
        if (this.isKeepPodOnFailure() != other.isKeepPodOnFailure()) {
            return false;
        }
        if (this.isTimestampAlignment() != other.isTimestampAlignment()) {
            return false;
        }
        RebuildMode this$rebuildMode = this.getRebuildMode();
        RebuildMode other$rebuildMode = other.getRebuildMode();
        if (this$rebuildMode == null ? other$rebuildMode != null : !this$rebuildMode.equals(other$rebuildMode)) {
            return false;
        }
        AlignmentPreference this$alignmentPreference = this.getAlignmentPreference();
        AlignmentPreference other$alignmentPreference = other.getAlignmentPreference();
        return !(this$alignmentPreference == null ? other$alignmentPreference != null : !this$alignmentPreference.equals(other$alignmentPreference));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BuildParameters;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTemporaryBuild() ? 79 : 97);
        result = result * 59 + (this.isBuildDependencies() ? 79 : 97);
        result = result * 59 + (this.isKeepPodOnFailure() ? 79 : 97);
        result = result * 59 + (this.isTimestampAlignment() ? 79 : 97);
        RebuildMode $rebuildMode = this.getRebuildMode();
        result = result * 59 + ($rebuildMode == null ? 43 : $rebuildMode.hashCode());
        AlignmentPreference $alignmentPreference = this.getAlignmentPreference();
        result = result * 59 + ($alignmentPreference == null ? 43 : $alignmentPreference.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BuildParameters(temporaryBuild=" + this.isTemporaryBuild() + ", rebuildMode=" + this.getRebuildMode() + ", buildDependencies=" + this.isBuildDependencies() + ", keepPodOnFailure=" + this.isKeepPodOnFailure() + ", timestampAlignment=" + this.isTimestampAlignment() + ", alignmentPreference=" + this.getAlignmentPreference() + ")";
    }
}

