/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.ArtifactRepo;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.rest.restmodel.GenericRestEntity;
import org.jboss.pnc.rest.utils.StreamHelper;
import org.jboss.pnc.rest.validation.groups.WhenCreatingNew;
import org.jboss.pnc.rest.validation.groups.WhenUpdating;

@XmlRootElement(name="Artifact")
public class ArtifactRest
implements GenericRestEntity<Integer> {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    private Integer id;
    @NotNull(groups={WhenCreatingNew.class, WhenUpdating.class})
    private String identifier;
    @ApiModelProperty(dataType="string")
    private Artifact.Quality artifactQuality;
    @ApiModelProperty(dataType="string")
    private ArtifactRepo.Type repoType;
    @NotNull(groups={WhenCreatingNew.class, WhenUpdating.class})
    private String checksum;
    private String filename;
    private String deployUrl;
    private Set<Integer> buildRecordIds;
    private Set<Integer> dependantBuildRecordIds;
    private Date importDate;
    private String originUrl;
    private Long size;

    public ArtifactRest() {
    }

    public ArtifactRest(Artifact artifact) {
        this.id = artifact.getId();
        this.identifier = artifact.getIdentifier();
        this.repoType = artifact.getRepoType();
        this.checksum = artifact.getChecksum();
        this.filename = artifact.getFilename();
        this.deployUrl = artifact.getDeployUrl();
        this.artifactQuality = artifact.getArtifactQuality();
        this.importDate = artifact.getImportDate();
        this.originUrl = artifact.getOriginUrl();
        this.buildRecordIds = StreamHelper.nullableStreamOf(artifact.getBuildRecords()).map(BuildRecord::getId).collect(Collectors.toSet());
        this.dependantBuildRecordIds = StreamHelper.nullableStreamOf(artifact.getDependantBuildRecords()).map(BuildRecord::getId).collect(Collectors.toSet());
        this.size = artifact.getSize();
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public ArtifactRepo.Type getRepoType() {
        return this.repoType;
    }

    public void setRepoType(ArtifactRepo.Type repoType) {
        this.repoType = repoType;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public Artifact.Quality getArtifactQuality() {
        return this.artifactQuality;
    }

    public void setArtifactQuality(Artifact.Quality artifactQuality) {
        this.artifactQuality = artifactQuality;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getDeployUrl() {
        return this.deployUrl;
    }

    public void setDeployUrl(String deployUrl) {
        this.deployUrl = deployUrl;
    }

    public Date getImportDate() {
        return this.importDate;
    }

    public void setImportDate(Date importDate) {
        this.importDate = importDate;
    }

    public String getOriginUrl() {
        return this.originUrl;
    }

    public void setOriginUrl(String originUrl) {
        this.originUrl = originUrl;
    }

    @JsonIgnore
    public boolean isImported() {
        return this.originUrl != null && !this.originUrl.isEmpty();
    }

    @Deprecated
    @JsonIgnore
    public String getStatus() {
        if (this.buildRecordIds != null && this.buildRecordIds.size() > 0) {
            return "BINARY_BUILT";
        }
        return "BINARY_IMPORTED";
    }

    public Set<Integer> getBuildRecordIds() {
        return this.buildRecordIds;
    }

    public void setBuildRecordIds(Set<Integer> buildRecordIds) {
        this.buildRecordIds = buildRecordIds;
    }

    @JsonIgnore
    public boolean isBuilt() {
        return this.buildRecordIds != null && this.buildRecordIds.size() > 0;
    }

    public Set<Integer> getDependantBuildRecordIds() {
        return this.dependantBuildRecordIds;
    }

    public void setDependantBuildRecordIds(Set<Integer> dependantBuildRecordIds) {
        this.dependantBuildRecordIds = dependantBuildRecordIds;
    }

    public Artifact.Builder toDBEntityBuilder() {
        Artifact.Builder builder = Artifact.Builder.newBuilder().id(this.getId()).identifier(this.getIdentifier()).checksum(this.getChecksum()).size(this.getSize()).repoType(this.getRepoType()).artifactQuality(this.getArtifactQuality()).deployUrl(this.getDeployUrl()).importDate(this.getImportDate()).originUrl(this.getOriginUrl()).filename(this.getFilename());
        StreamHelper.nullableStreamOf(this.getBuildRecordIds()).forEach(buildRecordId -> builder.buildRecord(BuildRecord.Builder.newBuilder().id(buildRecordId).build()));
        StreamHelper.nullableStreamOf(this.getDependantBuildRecordIds()).forEach(depBuildRecordId -> builder.dependantBuildRecord(BuildRecord.Builder.newBuilder().id(depBuildRecordId).build()));
        return builder;
    }

    public String toString() {
        return "ArtifactRest{id=" + this.id + ", identifier='" + this.identifier + '\'' + ", artifactQuality=" + this.artifactQuality + ", repoType=" + this.repoType + ", checksum='" + this.checksum + '\'' + ", filename='" + this.filename + '\'' + ", deployUrl='" + this.deployUrl + '\'' + ", buildRecordIds=" + this.buildRecordIds + ", dependantBuildRecordIds=" + this.dependantBuildRecordIds + ", importDate=" + this.importDate + ", originUrl='" + this.originUrl + '\'' + '}';
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }
}

