/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel;

import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.pnc.model.BuildConfigSetRecord;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.BuildStatus;
import org.jboss.pnc.rest.restmodel.GenericRestEntity;
import org.jboss.pnc.rest.utils.Utility;
import org.jboss.pnc.rest.validation.groups.WhenCreatingNew;
import org.jboss.pnc.rest.validation.groups.WhenUpdating;

@XmlRootElement(name="BuildRecord")
public class BuildConfigSetRecordRest
implements GenericRestEntity<Integer> {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    private Integer id;
    private Integer buildConfigurationSetId;
    private String buildConfigurationSetName;
    private Date startTime;
    private Date endTime;
    private BuildStatus status;
    private Integer userId;
    private String username;
    private Integer productVersionId;
    private Set<Integer> buildRecordIds;

    public BuildConfigSetRecordRest() {
    }

    public BuildConfigSetRecordRest(BuildConfigSetRecord buildConfigSetRecord) {
        Objects.requireNonNull(buildConfigSetRecord);
        this.id = buildConfigSetRecord.getId();
        this.startTime = buildConfigSetRecord.getStartTime();
        this.endTime = buildConfigSetRecord.getEndTime();
        Utility.performIfNotNull(buildConfigSetRecord.getBuildConfigurationSet(), () -> {
            this.buildConfigurationSetId = buildConfigSetRecord.getBuildConfigurationSet().getId();
        });
        Utility.performIfNotNull(buildConfigSetRecord.getBuildConfigurationSet(), () -> {
            this.buildConfigurationSetName = buildConfigSetRecord.getBuildConfigurationSet().getName();
        });
        Utility.performIfNotNull(buildConfigSetRecord.getUser(), () -> {
            this.userId = buildConfigSetRecord.getUser().getId();
        });
        Utility.performIfNotNull(buildConfigSetRecord.getUser(), () -> {
            this.username = buildConfigSetRecord.getUser().getUsername();
        });
        Utility.performIfNotNull(buildConfigSetRecord.getProductVersion(), () -> {
            this.productVersionId = buildConfigSetRecord.getProductVersion().getId();
        });
        this.status = buildConfigSetRecord.getStatus();
        Objects.requireNonNull(buildConfigSetRecord.getBuildRecords());
        this.buildRecordIds = buildConfigSetRecord.getBuildRecords().stream().map(BuildRecord::getId).collect(Collectors.toSet());
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public BuildStatus getStatus() {
        return this.status;
    }

    public void setStatus(BuildStatus status) {
        this.status = status;
    }

    public Integer getBuildConfigurationSetId() {
        return this.buildConfigurationSetId;
    }

    public void setBuildConfigurationSetId(Integer buildConfigurationSetId) {
        this.buildConfigurationSetId = buildConfigurationSetId;
    }

    public String getBuildConfigurationSetName() {
        return this.buildConfigurationSetName;
    }

    public void setBuildConfigurationSetName(String buildConfigurationSetName) {
        this.buildConfigurationSetName = buildConfigurationSetName;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Integer getProductVersionId() {
        return this.productVersionId;
    }

    public void setProductVersionId(Integer productVersionId) {
        this.productVersionId = productVersionId;
    }

    public Set<Integer> getBuildRecordIds() {
        return this.buildRecordIds;
    }
}

