/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel;

import java.util.Date;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.rest.restmodel.BuildEnvironmentRest;
import org.jboss.pnc.rest.restmodel.GenericRestEntity;
import org.jboss.pnc.rest.restmodel.ProjectRest;
import org.jboss.pnc.rest.utils.Utility;
import org.jboss.pnc.rest.validation.groups.WhenCreatingNew;
import org.jboss.pnc.rest.validation.groups.WhenUpdating;

@XmlRootElement(name="BuildConfigurationAudited")
public class BuildConfigurationAuditedRest
implements GenericRestEntity<Integer> {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    private Integer id;
    private Integer rev;
    private IdRev idRev;
    private String name;
    private String description;
    private String buildScript;
    private String scmRepoURL;
    private String scmRevision;
    private String scmExternalRepoURL;
    private String scmExternalRevision;
    @Deprecated
    private String scmMirrorRepoURL;
    @Deprecated
    private String scmMirrorRevision;
    private Date creationTime;
    private Date lastModificationTime;
    private String repositories;
    private Integer projectId;
    private Integer environmentId;
    private ProjectRest project;
    private BuildEnvironmentRest environment;

    public BuildConfigurationAuditedRest() {
    }

    public BuildConfigurationAuditedRest(BuildConfigurationAudited buildConfigurationAudited) {
        this.idRev = buildConfigurationAudited.getId();
        this.id = buildConfigurationAudited.getIdRev().getId();
        this.rev = buildConfigurationAudited.getRev();
        this.name = buildConfigurationAudited.getName();
        this.description = buildConfigurationAudited.getDescription();
        this.buildScript = buildConfigurationAudited.getBuildScript();
        this.scmRepoURL = buildConfigurationAudited.getScmRepoURL();
        this.scmRevision = buildConfigurationAudited.getScmRevision();
        this.scmExternalRepoURL = buildConfigurationAudited.getScmExternalRepoURL();
        this.scmExternalRevision = buildConfigurationAudited.getScmExternalRevision();
        Utility.performIfNotNull(buildConfigurationAudited.getProject(), () -> {
            this.project = new ProjectRest(buildConfigurationAudited.getProject());
        });
        Utility.performIfNotNull(buildConfigurationAudited.getBuildEnvironment(), () -> {
            this.environment = new BuildEnvironmentRest(buildConfigurationAudited.getBuildEnvironment());
        });
        Utility.performIfNotNull(this.project, () -> {
            this.projectId = this.project.getId();
        });
        Utility.performIfNotNull(this.environment, () -> {
            this.environmentId = this.environment.getId();
        });
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getRev() {
        return this.rev;
    }

    public void setRev(Integer rev) {
        this.rev = rev;
    }

    public IdRev getIdRev() {
        return this.idRev;
    }

    public void setIdRev(IdRev idRev) {
        this.idRev = idRev;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBuildScript() {
        return this.buildScript;
    }

    public void setBuildScript(String buildScript) {
        this.buildScript = buildScript;
    }

    public String getScmRepoURL() {
        return this.scmRepoURL;
    }

    public void setScmRepoURL(String scmRepoURL) {
        this.scmRepoURL = scmRepoURL;
    }

    public String getScmRevision() {
        return this.scmRevision;
    }

    public void setScmRevision(String scmRevision) {
        this.scmRevision = scmRevision;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getLastModificationTime() {
        return this.lastModificationTime;
    }

    public void setLastModificationTime(Date lastModificationTime) {
        this.lastModificationTime = lastModificationTime;
    }

    public String getRepositories() {
        return this.repositories;
    }

    public void setRepositories(String repositories) {
        this.repositories = repositories;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public Integer getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(Integer environmentId) {
        this.environmentId = environmentId;
    }

    public ProjectRest getProject() {
        return this.project;
    }

    public void setProject(ProjectRest project) {
        this.project = project;
    }

    public BuildEnvironmentRest getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(BuildEnvironmentRest environment) {
        this.environment = environment;
    }

    @XmlTransient
    public BuildConfigurationAudited.Builder toDBEntityBuilder() {
        BuildConfiguration.Builder buildConfigBuilder = BuildConfiguration.Builder.newBuilder().id(this.id).name(this.name).description(this.description).buildScript(this.buildScript).scmRepoURL(this.scmRepoURL).scmRevision(this.scmRevision).scmExternalRepoURL(this.scmExternalRepoURL).scmExternalRevision(this.scmRevision).creationTime(this.creationTime).lastModificationTime(this.lastModificationTime).repositories(this.repositories);
        Utility.performIfNotNull(this.project, () -> buildConfigBuilder.project(this.project.toDBEntityBuilder().build()));
        Utility.performIfNotNull(this.environment, () -> buildConfigBuilder.buildEnvironment(this.environment.toDBEntityBuilder().build()));
        BuildConfigurationAudited.Builder builder = BuildConfigurationAudited.Builder.newBuilder().buildConfiguration(buildConfigBuilder.build()).buildRecord(this.id);
        return builder;
    }

    public String getScmExternalRepoURL() {
        return this.scmExternalRepoURL;
    }

    public void setScmExternalRepoURL(String scmExternalRepoURL) {
        this.scmExternalRepoURL = scmExternalRepoURL;
    }

    public String getScmExternalRevision() {
        return this.scmExternalRevision;
    }

    public void setScmExternalRevision(String scmExternalRevision) {
        this.scmExternalRevision = scmExternalRevision;
    }

    @Deprecated
    public String getScmMirrorRepoURL() {
        return this.scmMirrorRepoURL;
    }

    @Deprecated
    public void setScmMirrorRepoURL(String scmMirrorRepoURL) {
        this.scmMirrorRepoURL = scmMirrorRepoURL;
    }

    @Deprecated
    public String getScmMirrorRevision() {
        return this.scmMirrorRevision;
    }

    @Deprecated
    public void setScmMirrorRevision(String scmMirrorRevision) {
        this.scmMirrorRevision = scmMirrorRevision;
    }
}

