/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel;

import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.ProductVersion;
import org.jboss.pnc.rest.restmodel.BuildEnvironmentRest;
import org.jboss.pnc.rest.restmodel.GenericRestEntity;
import org.jboss.pnc.rest.restmodel.ProjectRest;
import org.jboss.pnc.rest.utils.StreamHelper;
import org.jboss.pnc.rest.utils.Utility;
import org.jboss.pnc.rest.validation.groups.WhenCreatingNew;
import org.jboss.pnc.rest.validation.groups.WhenUpdating;
import org.jboss.pnc.rest.validation.validators.ScmUrl;

@XmlRootElement(name="Configuration")
public class BuildConfigurationRest
implements GenericRestEntity<Integer> {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    private Integer id;
    @NotNull(groups={WhenCreatingNew.class})
    @Pattern(regexp="^[a-zA-Z0-9_.][a-zA-Z0-9_.-]*(?<!\\.git)$", groups={WhenCreatingNew.class, WhenUpdating.class})
    private String name;
    private String description;
    private String buildScript;
    @NotNull(groups={WhenCreatingNew.class})
    @ScmUrl(groups={WhenCreatingNew.class, WhenUpdating.class})
    private String scmRepoURL;
    private String scmRevision;
    @ScmUrl(groups={WhenCreatingNew.class, WhenUpdating.class})
    private String scmExternalRepoURL;
    private String scmExternalRevision;
    @ScmUrl(groups={WhenCreatingNew.class, WhenUpdating.class})
    @Deprecated
    private String scmMirrorRepoURL;
    @Deprecated
    private String scmMirrorRevision;
    private Date creationTime;
    private Date lastModificationTime;
    private boolean archived;
    private String repositories;
    @NotNull(groups={WhenCreatingNew.class})
    private ProjectRest project;
    @NotNull(groups={WhenCreatingNew.class, WhenUpdating.class})
    private BuildEnvironmentRest environment;
    private Set<Integer> dependencyIds;
    private Integer productVersionId;

    public BuildConfigurationRest() {
    }

    public BuildConfigurationRest(BuildConfiguration buildConfiguration) {
        this.id = buildConfiguration.getId();
        this.name = buildConfiguration.getName();
        this.description = buildConfiguration.getDescription();
        this.buildScript = buildConfiguration.getBuildScript();
        this.scmRepoURL = buildConfiguration.getScmRepoURL();
        this.scmRevision = buildConfiguration.getScmRevision();
        this.scmExternalRepoURL = buildConfiguration.getScmExternalRepoURL();
        this.scmExternalRevision = buildConfiguration.getScmExternalRevision();
        this.creationTime = buildConfiguration.getCreationTime();
        this.lastModificationTime = buildConfiguration.getLastModificationTime();
        this.archived = buildConfiguration.isArchived();
        this.repositories = buildConfiguration.getRepositories();
        Utility.performIfNotNull(buildConfiguration.getProject(), () -> {
            this.project = new ProjectRest(buildConfiguration.getProject());
        });
        Utility.performIfNotNull(buildConfiguration.getBuildEnvironment(), () -> {
            this.environment = new BuildEnvironmentRest(buildConfiguration.getBuildEnvironment());
        });
        this.dependencyIds = StreamHelper.nullableStreamOf(buildConfiguration.getDependencies()).map(dependencyConfig -> dependencyConfig.getId()).collect(Collectors.toSet());
        Utility.performIfNotNull(buildConfiguration.getProductVersion(), () -> {
            this.productVersionId = buildConfiguration.getProductVersion().getId();
        });
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBuildScript() {
        return this.buildScript;
    }

    public void setBuildScript(String buildScript) {
        this.buildScript = buildScript;
    }

    public String getScmRepoURL() {
        return this.scmRepoURL;
    }

    public void setScmRepoURL(String scmRepoURL) {
        this.scmRepoURL = scmRepoURL;
    }

    public String getScmRevision() {
        return this.scmRevision;
    }

    public void setScmRevision(String scmRevision) {
        this.scmRevision = scmRevision;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getLastModificationTime() {
        return this.lastModificationTime;
    }

    public void setLastModificationTime(Date lastModificationTime) {
        this.lastModificationTime = lastModificationTime;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public String getRepositories() {
        return this.repositories;
    }

    public void setRepositories(String repositories) {
        this.repositories = repositories;
    }

    public ProjectRest getProject() {
        return this.project;
    }

    public void setProject(ProjectRest project) {
        this.project = project;
    }

    public Integer getProductVersionId() {
        return this.productVersionId;
    }

    public void setProductVersionId(Integer productVersionId) {
        this.productVersionId = productVersionId;
    }

    public Set<Integer> getDependencyIds() {
        return this.dependencyIds;
    }

    public void setDependencyIds(Set<Integer> dependencyIds) {
        this.dependencyIds = dependencyIds;
    }

    public boolean addDependency(Integer dependencyId) {
        return this.dependencyIds.add(dependencyId);
    }

    public boolean removeDependency(Integer dependencyId) {
        return this.dependencyIds.remove(dependencyId);
    }

    public BuildEnvironmentRest getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(BuildEnvironmentRest environment) {
        this.environment = environment;
    }

    public BuildConfiguration.Builder toDBEntityBuilder() {
        BuildConfiguration.Builder builder = BuildConfiguration.Builder.newBuilder().id(this.getId()).name(this.getName()).description(this.getDescription()).buildScript(this.getBuildScript()).scmRepoURL(this.getScmRepoURL()).scmRevision(this.getScmRevision()).scmExternalRepoURL(this.getScmExternalRepoURL()).scmExternalRevision(this.getScmExternalRevision()).archived(this.isArchived()).repositories(this.getRepositories());
        Utility.performIfNotNull(this.getProject(), () -> builder.project(this.getProject().toDBEntityBuilder().build()));
        Utility.performIfNotNull(this.getEnvironment(), () -> builder.buildEnvironment(this.getEnvironment().toDBEntityBuilder().build()));
        Utility.performIfNotNull(this.getProductVersionId(), () -> builder.productVersion(ProductVersion.Builder.newBuilder().id(this.productVersionId).build()));
        StreamHelper.nullableStreamOf(this.getDependencyIds()).forEach(dependencyId -> {
            BuildConfiguration.Builder buildConfigurationBuilder = BuildConfiguration.Builder.newBuilder().id(dependencyId);
            builder.dependency(buildConfigurationBuilder.build());
        });
        return builder;
    }

    public String getScmExternalRepoURL() {
        return this.scmExternalRepoURL;
    }

    public void setScmExternalRepoURL(String scmExternalRepoURL) {
        this.scmExternalRepoURL = scmExternalRepoURL;
    }

    public String getScmExternalRevision() {
        return this.scmExternalRevision;
    }

    public void setScmExternalRevision(String scmExternalRevision) {
        this.scmExternalRevision = scmExternalRevision;
    }

    @Deprecated
    public String getScmMirrorRepoURL() {
        return this.scmMirrorRepoURL;
    }

    @Deprecated
    public void setScmMirrorRepoURL(String scmMirrorRepoURL) {
        this.scmMirrorRepoURL = scmMirrorRepoURL;
    }

    @Deprecated
    public String getScmMirrorRevision() {
        return this.scmMirrorRevision;
    }

    @Deprecated
    public void setScmMirrorRevision(String scmMirrorRevision) {
        this.scmMirrorRevision = scmMirrorRevision;
    }
}

