/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel;

import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.model.ProductRelease;
import org.jboss.pnc.rest.restmodel.GenericRestEntity;
import org.jboss.pnc.rest.utils.Utility;
import org.jboss.pnc.rest.validation.groups.WhenCreatingNew;
import org.jboss.pnc.rest.validation.groups.WhenUpdating;

@XmlRootElement(name="ProductRelease")
public class ProductReleaseRest
implements GenericRestEntity<Integer> {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    private Integer id;
    private String version;
    private Date releaseDate;
    private String downloadUrl;
    private String issueTrackerUrl;
    private Integer productVersionId;
    private Integer productMilestoneId;
    @ApiModelProperty(dataType="string")
    private ProductRelease.SupportLevel supportLevel;

    public ProductReleaseRest() {
    }

    public ProductReleaseRest(ProductRelease productRelease) {
        this.id = productRelease.getId();
        this.version = productRelease.getVersion();
        this.releaseDate = productRelease.getReleaseDate();
        this.downloadUrl = productRelease.getDownloadUrl();
        this.issueTrackerUrl = productRelease.getIssueTrackerUrl();
        this.productVersionId = productRelease.getProductVersion().getId();
        if (productRelease.getProductMilestone() != null) {
            this.productMilestoneId = productRelease.getProductMilestone().getId();
        }
        this.supportLevel = productRelease.getSupportLevel();
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(Date releaseDate) {
        this.releaseDate = releaseDate;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public String getIssueTrackerUrl() {
        return this.issueTrackerUrl;
    }

    public void setIssueTrackerUrl(String issueTrackerUrl) {
        this.issueTrackerUrl = issueTrackerUrl;
    }

    public Integer getProductVersionId() {
        return this.productVersionId;
    }

    public void setProductVersionId(Integer productVersionId) {
        this.productVersionId = productVersionId;
    }

    public Integer getProductMilestoneId() {
        return this.productMilestoneId;
    }

    public void setProductMilestoneId(Integer productMilestoneId) {
        this.productMilestoneId = productMilestoneId;
    }

    public ProductRelease.SupportLevel getSupportLevel() {
        return this.supportLevel;
    }

    public void setSupportLevel(ProductRelease.SupportLevel supportLevel) {
        this.supportLevel = supportLevel;
    }

    public ProductRelease.Builder toDBEntityBuilder() {
        ProductRelease.Builder builder = ProductRelease.Builder.newBuilder().id(this.id).version(this.version).releaseDate(this.releaseDate).downloadUrl(this.downloadUrl).issueTrackerUrl(this.issueTrackerUrl).supportLevel(this.supportLevel);
        Utility.performIfNotNull(this.productMilestoneId, () -> builder.productMilestone(ProductMilestone.Builder.newBuilder().id(this.productMilestoneId).build()));
        return builder;
    }
}

