/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.pnc.model.Product;
import org.jboss.pnc.model.ProductVersion;
import org.jboss.pnc.rest.restmodel.GenericRestEntity;
import org.jboss.pnc.rest.restmodel.ProductVersionRest;
import org.jboss.pnc.rest.utils.StreamHelper;
import org.jboss.pnc.rest.validation.groups.WhenCreatingNew;
import org.jboss.pnc.rest.validation.groups.WhenUpdating;

@XmlRootElement(name="Product")
public class ProductRest
implements GenericRestEntity<Integer> {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    private Integer id;
    private String name;
    private String description;
    private String abbreviation;
    private String productCode;
    private String pgmSystemName;
    private List<Integer> productVersionIds;
    private Set<ProductVersionRest> productVersions;

    public ProductRest() {
    }

    public ProductRest(Product product) {
        this.id = product.getId();
        this.name = product.getName();
        this.description = product.getDescription();
        this.abbreviation = product.getAbbreviation();
        this.productCode = product.getProductCode();
        this.pgmSystemName = product.getPgmSystemName();
        this.productVersionIds = StreamHelper.nullableStreamOf(product.getProductVersions()).map(productVersion -> productVersion.getId()).collect(Collectors.toList());
        this.productVersions = StreamHelper.nullableStreamOf(product.getProductVersions()).map(productVersion -> new ProductVersionRest((ProductVersion)productVersion)).collect(Collectors.toSet());
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getPgmSystemName() {
        return this.pgmSystemName;
    }

    public void setPgmSystemName(String pgmSystemName) {
        this.pgmSystemName = pgmSystemName;
    }

    public List<Integer> getProductVersionIds() {
        return this.productVersionIds;
    }

    public void setProductVersionIds(List<Integer> productVersionIds) {
        this.productVersionIds = productVersionIds;
    }

    public Set<ProductVersionRest> getProductVersions() {
        return this.productVersions;
    }

    public void setProductVersions(Set<ProductVersionRest> productVersions) {
        this.productVersions = productVersions;
    }

    public Product.Builder toDBEntityBuilder() {
        Product.Builder builder = Product.Builder.newBuilder().id(this.id).name(this.name).description(this.description).abbreviation(this.abbreviation).productCode(this.productCode).pgmSystemName(this.pgmSystemName);
        StreamHelper.nullableStreamOf(this.productVersionIds).forEach(productVersionId -> {
            ProductVersion.Builder productVersionBuilder = ProductVersion.Builder.newBuilder().id(productVersionId);
            builder.productVersion(productVersionBuilder);
        });
        return builder;
    }
}

