/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.rest.restmodel.ArtifactRest;
import org.jboss.pnc.spi.repositorymanager.RepositoryManagerResult;
import org.jboss.pnc.spi.repositorymanager.RepositoryManagerStatus;

@XmlRootElement(name="repositoryManagerResult")
public class RepositoryManagerResultRest
implements Serializable {
    private List<ArtifactRest> builtArtifacts;
    private List<ArtifactRest> dependencies;
    private String buildContentId;
    private String log;
    private RepositoryManagerStatus status;

    public RepositoryManagerResultRest() {
    }

    public RepositoryManagerResultRest(RepositoryManagerResult result) {
        this.builtArtifacts = result.getBuiltArtifacts().stream().map(artifact -> new ArtifactRest((Artifact)artifact)).collect(Collectors.toList());
        this.dependencies = result.getDependencies().stream().map(artifact -> new ArtifactRest((Artifact)artifact)).collect(Collectors.toList());
        this.buildContentId = result.getBuildContentId();
        this.log = result.getLog();
        this.status = result.getStatus();
    }

    public List<ArtifactRest> getBuiltArtifacts() {
        return this.builtArtifacts;
    }

    public List<ArtifactRest> getDependencies() {
        return this.dependencies;
    }

    public String getBuildContentId() {
        return this.buildContentId;
    }

    public String getLog() {
        return this.log;
    }

    public RepositoryManagerStatus getStatus() {
        return this.status;
    }

    public RepositoryManagerResult toRepositoryManagerResult() {
        List<Artifact> builtArtifacts = this.getBuiltArtifacts().stream().map(artifactRest -> artifactRest.toDBEntityBuilder().build()).collect(Collectors.toList());
        List<Artifact> dependencies = this.getDependencies().stream().map(artifactRest -> artifactRest.toDBEntityBuilder().build()).collect(Collectors.toList());
        String buildContentId = this.getBuildContentId();
        return new GenericRepositoryManagerResult(builtArtifacts, dependencies, buildContentId, this.log, this.status);
    }

    private class GenericRepositoryManagerResult
    implements RepositoryManagerResult {
        private final List<Artifact> builtArtifacts;
        private final List<Artifact> dependencies;
        private final String buildContentId;
        private final String log;
        private final RepositoryManagerStatus status;

        public GenericRepositoryManagerResult(List<Artifact> builtArtifacts, List<Artifact> dependencies, String buildContentId, String log, RepositoryManagerStatus status) {
            this.builtArtifacts = builtArtifacts;
            this.dependencies = dependencies;
            this.buildContentId = buildContentId;
            this.log = log;
            this.status = status;
        }

        public List<Artifact> getBuiltArtifacts() {
            return this.builtArtifacts;
        }

        public List<Artifact> getDependencies() {
            return this.dependencies;
        }

        public String getBuildContentId() {
            return this.buildContentId;
        }

        public String getLog() {
            return this.log;
        }

        public RepositoryManagerStatus getStatus() {
            return this.status;
        }
    }
}

