/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel.bpm;

import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.pnc.rest.restmodel.BuildDriverResultRest;
import org.jboss.pnc.rest.restmodel.BuildExecutionConfigurationRest;
import org.jboss.pnc.rest.restmodel.RepositoryManagerResultRest;
import org.jboss.pnc.rest.restmodel.bpm.BpmNotificationRest;
import org.jboss.pnc.rest.utils.JsonOutputConverterMapper;
import org.jboss.pnc.spi.BuildExecutionStatus;
import org.jboss.pnc.spi.BuildResult;
import org.jboss.pnc.spi.SshCredentials;
import org.jboss.pnc.spi.builddriver.BuildDriverResult;
import org.jboss.pnc.spi.executor.BuildExecutionConfiguration;
import org.jboss.pnc.spi.executor.exceptions.ExecutorException;
import org.jboss.pnc.spi.repositorymanager.RepositoryManagerResult;

@XmlRootElement(name="buildResult")
public class BuildResultRest
extends BpmNotificationRest
implements Serializable {
    private BuildExecutionConfigurationRest buildExecutionConfiguration;
    private BuildDriverResultRest buildDriverResult;
    private RepositoryManagerResultRest repositoryManagerResult;
    private ExecutorException exception;
    private BuildExecutionStatus failedReasonStatus;
    private SshCredentials sshCredentials;
    private String executionRootName;
    private String executionRootVersion;

    public BuildResultRest() {
    }

    public BuildResultRest(String serialized) throws IOException {
        BuildResultRest buildResultRest = JsonOutputConverterMapper.readValue(serialized, BuildResultRest.class);
        this.buildExecutionConfiguration = buildResultRest.getBuildExecutionConfiguration();
        this.buildDriverResult = buildResultRest.getBuildDriverResult();
        this.repositoryManagerResult = buildResultRest.getRepositoryManagerResult();
        this.exception = buildResultRest.getException();
        this.failedReasonStatus = buildResultRest.getFailedReasonStatus();
        this.sshCredentials = buildResultRest.getSshCredentials();
        this.executionRootName = buildResultRest.getExecutionRootName();
        this.executionRootVersion = buildResultRest.getExecutionRootVersion();
    }

    public BuildResultRest(BuildResult buildResult) {
        buildResult.getBuildExecutionConfiguration().ifPresent(configuration -> {
            this.buildExecutionConfiguration = new BuildExecutionConfigurationRest((BuildExecutionConfiguration)configuration);
        });
        if (buildResult.getBuildDriverResult().isPresent()) {
            BuildDriverResult result2 = (BuildDriverResult)buildResult.getBuildDriverResult().get();
            this.buildDriverResult = new BuildDriverResultRest(result2);
        }
        buildResult.getRepositoryManagerResult().ifPresent(result -> {
            this.repositoryManagerResult = new RepositoryManagerResultRest((RepositoryManagerResult)result);
        });
        this.failedReasonStatus = buildResult.getFailedReasonStatus().orElse(null);
        this.exception = buildResult.getException().orElse(null);
        this.sshCredentials = buildResult.getSshCredentials().orElse(null);
    }

    public BuildResult toBuildResult() {
        RepositoryManagerResult repositoryManagerResult = null;
        if (this.getRepositoryManagerResult() != null) {
            repositoryManagerResult = this.getRepositoryManagerResult().toRepositoryManagerResult();
        }
        return new BuildResult(Optional.ofNullable(this.buildExecutionConfiguration), Optional.ofNullable(this.buildDriverResult), Optional.ofNullable(repositoryManagerResult), Optional.ofNullable(this.exception), Optional.ofNullable(this.failedReasonStatus), Optional.ofNullable(this.sshCredentials), Optional.ofNullable(this.executionRootName), Optional.ofNullable(this.executionRootVersion));
    }

    @Override
    public String getEventType() {
        return "BUILD_COMPLETE";
    }

    @Override
    public String toString() {
        return JsonOutputConverterMapper.apply(this);
    }

    public BuildExecutionConfigurationRest getBuildExecutionConfiguration() {
        return this.buildExecutionConfiguration;
    }

    public void setBuildExecutionConfiguration(BuildExecutionConfigurationRest buildExecutionConfiguration) {
        this.buildExecutionConfiguration = buildExecutionConfiguration;
    }

    public BuildDriverResultRest getBuildDriverResult() {
        return this.buildDriverResult;
    }

    public void setBuildDriverResult(BuildDriverResultRest buildDriverResult) {
        this.buildDriverResult = buildDriverResult;
    }

    public RepositoryManagerResultRest getRepositoryManagerResult() {
        return this.repositoryManagerResult;
    }

    public void setRepositoryManagerResult(RepositoryManagerResultRest repositoryManagerResult) {
        this.repositoryManagerResult = repositoryManagerResult;
    }

    public ExecutorException getException() {
        return this.exception;
    }

    public void setException(ExecutorException exception) {
        this.exception = exception;
    }

    public BuildExecutionStatus getFailedReasonStatus() {
        return this.failedReasonStatus;
    }

    public void setFailedReasonStatus(BuildExecutionStatus failedReasonStatus) {
        this.failedReasonStatus = failedReasonStatus;
    }

    public SshCredentials getSshCredentials() {
        return this.sshCredentials;
    }

    public void setSshCredentials(SshCredentials sshCredentials) {
        this.sshCredentials = sshCredentials;
    }

    public String getExecutionRootName() {
        return this.executionRootName;
    }

    public void setExecutionRootName(String executionRootName) {
        this.executionRootName = executionRootName;
    }

    public String getExecutionRootVersion() {
        return this.executionRootVersion;
    }

    public void setExecutionRootVersion(String executionRootVersion) {
        this.executionRootVersion = executionRootVersion;
    }
}

