/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk7.Jdk7Module;
import java.io.IOException;
import org.jboss.logging.Logger;

public class JsonOutputConverterMapper {
    public static final Logger log = Logger.getLogger(JsonOutputConverterMapper.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String apply(Object objectToBeConverted) {
        if (objectToBeConverted != null) {
            try {
                return mapper.writeValueAsString(objectToBeConverted);
            }
            catch (JsonProcessingException e) {
                log.warn((Object)"Could not convert object to JSON", (Throwable)e);
                throw new IllegalArgumentException("Could not convert object to JSON", e);
            }
        }
        return "{}";
    }

    public static <T> T readValue(String serialized, Class<T> clazz) throws IOException {
        return (T)mapper.readValue(serialized, clazz);
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.registerModule((Module)new Jdk7Module());
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

