/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.pnc.model.SystemImageType;
import org.jboss.pnc.rest.restmodel.BuildConfigurationAuditedRest;
import org.jboss.pnc.rest.restmodel.UserRest;
import org.jboss.pnc.rest.utils.JsonOutputConverterMapper;
import org.jboss.pnc.spi.executor.BuildExecutionConfiguration;

@XmlRootElement(name="buildExecutionConfiguration")
public class BuildExecutionConfigurationRest
implements BuildExecutionConfiguration {
    private int id;
    private String buildContentId;
    private UserRest user;
    private String buildScript;
    private String name;
    private String scmRepoURL;
    private String scmRevision;
    private String systemImageId;
    private String systemImageRepositoryUrl;
    private SystemImageType systemImageType;
    private boolean podKeptOnFailure = false;
    private Map<String, String> genericParameters;

    public BuildExecutionConfigurationRest() {
    }

    public BuildExecutionConfigurationRest(String serialized) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        BuildExecutionConfigurationRest buildExecutionConfigurationRestFromJson = (BuildExecutionConfigurationRest)mapper.readValue(serialized, BuildExecutionConfigurationRest.class);
        BuildExecutionConfiguration buildExecutionConfiguration = buildExecutionConfigurationRestFromJson.toBuildExecutionConfiguration();
        this.init(buildExecutionConfiguration);
    }

    public BuildExecutionConfigurationRest(BuildExecutionConfiguration buildExecutionConfiguration) {
        this.init(buildExecutionConfiguration);
    }

    private void init(BuildExecutionConfiguration buildExecutionConfiguration) {
        this.id = buildExecutionConfiguration.getId();
        this.buildContentId = buildExecutionConfiguration.getBuildContentId();
        this.buildScript = buildExecutionConfiguration.getBuildScript();
        this.name = buildExecutionConfiguration.getName();
        this.scmRepoURL = buildExecutionConfiguration.getScmRepoURL();
        this.scmRevision = buildExecutionConfiguration.getScmRevision();
        this.systemImageId = buildExecutionConfiguration.getSystemImageId();
        this.systemImageRepositoryUrl = buildExecutionConfiguration.getSystemImageRepositoryUrl();
        this.systemImageType = buildExecutionConfiguration.getSystemImageType();
        this.user = new UserRest(buildExecutionConfiguration.getUserId());
        this.podKeptOnFailure = buildExecutionConfiguration.isPodKeptOnFailure();
        this.genericParameters = buildExecutionConfiguration.getGenericParameters();
    }

    public BuildExecutionConfiguration toBuildExecutionConfiguration() {
        return BuildExecutionConfiguration.build((int)this.id, (String)this.buildContentId, (Integer)this.user.getId(), (String)this.buildScript, (String)this.name, (String)this.scmRepoURL, (String)this.scmRevision, (String)this.systemImageId, (String)this.systemImageRepositoryUrl, (SystemImageType)this.systemImageType, (boolean)this.podKeptOnFailure, this.genericParameters);
    }

    public BuildConfigurationAuditedRest createBuildConfigurationAuditedRest() {
        BuildConfigurationAuditedRest buildConfigAuditedRest = new BuildConfigurationAuditedRest();
        buildConfigAuditedRest.setId(this.id);
        buildConfigAuditedRest.setRev(null);
        buildConfigAuditedRest.setName(this.name);
        buildConfigAuditedRest.setBuildScript(this.buildScript);
        buildConfigAuditedRest.setScmRepoURL(this.scmRepoURL);
        buildConfigAuditedRest.setScmRevision(this.scmRevision);
        return buildConfigAuditedRest;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setBuildContentId(String buildContentId) {
        this.buildContentId = buildContentId;
    }

    public void setBuildScript(String buildScript) {
        this.buildScript = buildScript;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setScmRepoURL(String scmRepoURL) {
        this.scmRepoURL = scmRepoURL;
    }

    public void setScmRevision(String scmRevision) {
        this.scmRevision = scmRevision;
    }

    public int getId() {
        return this.id;
    }

    @JsonIgnore
    public Integer getUserId() {
        return this.user.getId();
    }

    public String getBuildContentId() {
        return this.buildContentId;
    }

    public String getBuildScript() {
        return this.buildScript;
    }

    public String getName() {
        return this.name;
    }

    public String getScmRepoURL() {
        return this.scmRepoURL;
    }

    public String getScmRevision() {
        return this.scmRevision;
    }

    @Deprecated
    public String getBuildType() {
        return "";
    }

    public UserRest getUser() {
        return this.user;
    }

    public void setUser(UserRest user) {
        this.user = user;
    }

    @Deprecated
    public void setBuildType(String buildType) {
    }

    public String getSystemImageId() {
        return this.systemImageId;
    }

    public void setSystemImageId(String systemImageId) {
        this.systemImageId = systemImageId;
    }

    public String getSystemImageRepositoryUrl() {
        return this.systemImageRepositoryUrl;
    }

    public void setSystemImageRepositoryUrl(String systemImageRepositoryUrl) {
        this.systemImageRepositoryUrl = systemImageRepositoryUrl;
    }

    public SystemImageType getSystemImageType() {
        return this.systemImageType;
    }

    public boolean isPodKeptOnFailure() {
        return this.podKeptOnFailure;
    }

    public void setPodKeptOnFailure(boolean podKeptOnFailure) {
        this.podKeptOnFailure = podKeptOnFailure;
    }

    public void setSystemImageType(SystemImageType systemImageType) {
        this.systemImageType = systemImageType;
    }

    public void setGenericParameters(Map<String, String> genericParameters) {
        this.genericParameters = genericParameters;
    }

    public Map<String, String> getGenericParameters() {
        return this.genericParameters;
    }

    public String toString() {
        return JsonOutputConverterMapper.apply(this);
    }
}

