/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel;

import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.model.ProductVersion;
import org.jboss.pnc.rest.restmodel.GenericRestEntity;
import org.jboss.pnc.rest.utils.StreamHelper;
import org.jboss.pnc.rest.validation.groups.WhenCreatingNew;
import org.jboss.pnc.rest.validation.groups.WhenUpdating;

@XmlRootElement(name="ProductMilestone")
public class ProductMilestoneRest
implements GenericRestEntity<Integer> {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    private Integer id;
    @NotNull(groups={WhenCreatingNew.class, WhenUpdating.class})
    private String version;
    private Date endDate;
    private Date startingDate;
    private Date plannedEndDate;
    private String downloadUrl;
    private String issueTrackerUrl;
    @NotNull(groups={WhenCreatingNew.class, WhenUpdating.class})
    private Integer productVersionId;
    private Set<Integer> performedBuilds;
    private Set<Integer> distributedArtifactIds;
    private Integer productReleaseId;

    public ProductMilestoneRest() {
    }

    public ProductMilestoneRest(Integer id) {
        this.id = id;
    }

    public ProductMilestoneRest(ProductMilestone productMilestone) {
        this.id = productMilestone.getId();
        this.version = productMilestone.getVersion();
        this.endDate = productMilestone.getEndDate();
        this.startingDate = productMilestone.getStartingDate();
        this.plannedEndDate = productMilestone.getPlannedEndDate();
        this.downloadUrl = productMilestone.getDownloadUrl();
        this.issueTrackerUrl = productMilestone.getIssueTrackerUrl();
        this.productVersionId = productMilestone.getProductVersion().getId();
        this.performedBuilds = StreamHelper.nullableStreamOf(productMilestone.getPerformedBuilds()).map(BuildRecord::getId).collect(Collectors.toSet());
        this.distributedArtifactIds = StreamHelper.nullableStreamOf(productMilestone.getDistributedArtifacts()).map(Artifact::getId).collect(Collectors.toSet());
        if (productMilestone.getProductRelease() != null) {
            this.productReleaseId = productMilestone.getProductRelease().getId();
        }
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getStartingDate() {
        return this.startingDate;
    }

    public void setStartingDate(Date startingDate) {
        this.startingDate = startingDate;
    }

    public Date getPlannedEndDate() {
        return this.plannedEndDate;
    }

    public void setPlannedEndDate(Date plannedEndDate) {
        this.plannedEndDate = plannedEndDate;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public String getIssueTrackerUrl() {
        return this.issueTrackerUrl;
    }

    public void setIssueTrackerUrl(String issueTrackerUrl) {
        this.issueTrackerUrl = issueTrackerUrl;
    }

    public Integer getProductVersionId() {
        return this.productVersionId;
    }

    public void setProductVersionId(Integer productVersionId) {
        this.productVersionId = productVersionId;
    }

    public Integer getProductReleaseId() {
        return this.productReleaseId;
    }

    public void setProductReleaseId(Integer productReleaseId) {
        this.productReleaseId = productReleaseId;
    }

    public Set<Integer> getPerformedBuilds() {
        return this.performedBuilds;
    }

    public void setPerformedBuildRecordSetId(Set<Integer> performedBuilds) {
        this.performedBuilds = performedBuilds;
    }

    public Set<Integer> getDistributedArtifactIds() {
        return this.distributedArtifactIds;
    }

    public void setDistributedBuildRecordSetId(Set<Integer> distributedArtifactIds) {
        this.distributedArtifactIds = distributedArtifactIds;
    }

    public ProductMilestone.Builder toDBEntityBuilder() {
        ProductMilestone.Builder builder = ProductMilestone.Builder.newBuilder().id(this.id).version(this.getVersion()).startingDate(this.getStartingDate()).endDate(this.getEndDate()).plannedEndDate(this.getPlannedEndDate()).downloadUrl(this.getDownloadUrl()).issueTrackerUrl(this.issueTrackerUrl).productVersion(ProductVersion.Builder.newBuilder().id(this.productVersionId).build());
        StreamHelper.nullableStreamOf(this.getDistributedArtifactIds()).forEach(artifactId -> {
            Artifact.Builder artifactBuilder = Artifact.Builder.newBuilder().id(artifactId);
            builder.distributedArtifact(artifactBuilder.build());
        });
        StreamHelper.nullableStreamOf(this.getPerformedBuilds()).forEach(buildRecordId -> {
            BuildRecord.Builder buildRecordBuilder = BuildRecord.Builder.newBuilder().id(buildRecordId);
            builder.performedBuild(buildRecordBuilder.build());
        });
        return builder;
    }
}

