/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel;

import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.License;
import org.jboss.pnc.model.Project;
import org.jboss.pnc.rest.restmodel.GenericRestEntity;
import org.jboss.pnc.rest.utils.StreamHelper;
import org.jboss.pnc.rest.utils.Utility;
import org.jboss.pnc.rest.validation.groups.WhenCreatingNew;
import org.jboss.pnc.rest.validation.groups.WhenUpdating;

@XmlRootElement(name="Project")
public class ProjectRest
implements GenericRestEntity<Integer> {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    private Integer id;
    private String name;
    private String description;
    private String issueTrackerUrl;
    private String projectUrl;
    @ApiModelProperty(notes="Projects cannot set build configurations", readOnly=true)
    private List<Integer> configurationIds;
    private Integer licenseId;

    public ProjectRest() {
    }

    public ProjectRest(Project project) {
        this.id = project.getId();
        this.description = project.getDescription();
        this.name = project.getName();
        this.issueTrackerUrl = project.getIssueTrackerUrl();
        this.projectUrl = project.getProjectUrl();
        this.configurationIds = StreamHelper.nullableStreamOf(project.getBuildConfigurations()).map(buildConfiguration -> buildConfiguration.getId()).collect(Collectors.toList());
        Utility.performIfNotNull(project.getLicense(), () -> {
            this.licenseId = project.getLicense().getId();
        });
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIssueTrackerUrl() {
        return this.issueTrackerUrl;
    }

    public void setIssueTrackerUrl(String issueTrackerUrl) {
        this.issueTrackerUrl = issueTrackerUrl;
    }

    public String getProjectUrl() {
        return this.projectUrl;
    }

    public void setProjectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
    }

    public List<Integer> getConfigurationIds() {
        return this.configurationIds;
    }

    public void setConfigurationIds(List<Integer> configurationIds) {
        this.configurationIds = configurationIds;
    }

    public Integer getLicenseId() {
        return this.licenseId;
    }

    public void setLicenseId(Integer licenseId) {
        this.licenseId = licenseId;
    }

    public Project.Builder toDBEntityBuilder() {
        Project.Builder builder = Project.Builder.newBuilder().id(this.id).name(this.name).description(this.description).issueTrackerUrl(this.issueTrackerUrl).projectUrl(this.projectUrl);
        Utility.performIfNotNull(this.licenseId, () -> builder.license(License.Builder.newBuilder().id(this.licenseId).build()));
        StreamHelper.nullableStreamOf(this.configurationIds).forEach(configurationId -> builder.buildConfiguration(BuildConfiguration.Builder.newBuilder().id(configurationId).build()));
        return builder;
    }
}

