/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel.bpm;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.pnc.common.util.StringUtils;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.BuildStatus;
import org.jboss.pnc.rest.restmodel.BuildDriverResultRest;
import org.jboss.pnc.rest.restmodel.BuildExecutionConfigurationRest;
import org.jboss.pnc.rest.restmodel.RepositoryManagerResultRest;
import org.jboss.pnc.rest.restmodel.bpm.BpmNotificationRest;
import org.jboss.pnc.rest.utils.JsonOutputConverterMapper;
import org.jboss.pnc.spi.BuildResult;
import org.jboss.pnc.spi.builddriver.BuildDriverResult;
import org.jboss.pnc.spi.coordinator.CompletionStatus;
import org.jboss.pnc.spi.coordinator.ProcessException;
import org.jboss.pnc.spi.environment.EnvironmentDriverResult;
import org.jboss.pnc.spi.executor.BuildExecutionConfiguration;
import org.jboss.pnc.spi.repositorymanager.RepositoryManagerResult;
import org.jboss.pnc.spi.repour.RepourResult;

@XmlRootElement(name="buildResult")
public class BuildResultRest
extends BpmNotificationRest
implements Serializable {
    private CompletionStatus completionStatus;
    private ProcessException processException;
    private String processLog;
    private BuildExecutionConfigurationRest buildExecutionConfiguration;
    private BuildDriverResultRest buildDriverResult;
    private RepositoryManagerResultRest repositoryManagerResult;
    private EnvironmentDriverResult environmentDriverResult;
    private RepourResult repourResult;

    public static BuildResultRest valueOf(String serialized) throws IOException {
        return JsonOutputConverterMapper.readValue(serialized, BuildResultRest.class);
    }

    public BuildResultRest(BuildResult buildResult) {
        BuildDriverResult result;
        this.completionStatus = buildResult.getCompletionStatus();
        this.processException = buildResult.getProcessException().orElse(null);
        this.processLog = buildResult.getProcessLog();
        if (buildResult.getBuildExecutionConfiguration().isPresent()) {
            BuildExecutionConfiguration bec = (BuildExecutionConfiguration)buildResult.getBuildExecutionConfiguration().get();
            this.buildExecutionConfiguration = new BuildExecutionConfigurationRest(bec);
        } else {
            this.buildExecutionConfiguration = null;
        }
        if (buildResult.getBuildDriverResult().isPresent()) {
            result = (BuildDriverResult)buildResult.getBuildDriverResult().get();
            this.buildDriverResult = new BuildDriverResultRest(result);
        } else {
            this.buildDriverResult = null;
        }
        if (buildResult.getRepositoryManagerResult().isPresent()) {
            result = (RepositoryManagerResult)buildResult.getRepositoryManagerResult().get();
            this.repositoryManagerResult = new RepositoryManagerResultRest((RepositoryManagerResult)result);
        } else {
            this.repositoryManagerResult = null;
        }
        this.environmentDriverResult = buildResult.getEnvironmentDriverResult().isPresent() ? (EnvironmentDriverResult)buildResult.getEnvironmentDriverResult().get() : null;
        this.repourResult = buildResult.getRepourResult().orElse(null);
    }

    public BuildResult toBuildResult() {
        RepositoryManagerResult repositoryManagerResult = null;
        if (this.getRepositoryManagerResult() != null) {
            repositoryManagerResult = this.getRepositoryManagerResult().toRepositoryManagerResult();
        }
        return new BuildResult(this.completionStatus, Optional.ofNullable(this.processException), this.processLog, Optional.ofNullable(this.buildExecutionConfiguration), Optional.ofNullable(this.buildDriverResult), Optional.ofNullable(repositoryManagerResult), Optional.ofNullable(this.environmentDriverResult), Optional.ofNullable(this.repourResult));
    }

    @Override
    public String getEventType() {
        return "BUILD_COMPLETE";
    }

    @Override
    public String toString() {
        return JsonOutputConverterMapper.apply(this);
    }

    public String toLogString(final int maxStringLength) {
        BuildDriverResult buildDriverResult = null;
        if (this.buildDriverResult != null) {
            buildDriverResult = new BuildDriverResult(){

                public String getBuildLog() {
                    return StringUtils.trim((String)BuildResultRest.this.buildDriverResult.getBuildLog(), (int)maxStringLength);
                }

                public BuildStatus getBuildStatus() {
                    return BuildResultRest.this.buildDriverResult.getBuildStatus();
                }
            };
        }
        RepositoryManagerResultImpl repositoryManagerResult = null;
        if (this.repositoryManagerResult != null) {
            repositoryManagerResult = new RepositoryManagerResultImpl(this.repositoryManagerResult.toRepositoryManagerResult(), maxStringLength);
        }
        BuildResult buildResult = new BuildResult(this.completionStatus, Optional.ofNullable(this.processException), StringUtils.trim((String)this.processLog, (int)maxStringLength), Optional.ofNullable(this.buildExecutionConfiguration), Optional.ofNullable(buildDriverResult), Optional.ofNullable(repositoryManagerResult), Optional.ofNullable(this.environmentDriverResult), Optional.ofNullable(this.repourResult));
        return JsonOutputConverterMapper.apply(new BuildResultRest(buildResult));
    }

    @Deprecated
    public BuildResultRest() {
    }

    public CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    @Deprecated
    public void setCompletionStatus(CompletionStatus completionStatus) {
        this.completionStatus = completionStatus;
    }

    public ProcessException getProcessException() {
        return this.processException;
    }

    @Deprecated
    public void setProcessException(ProcessException processException) {
        this.processException = processException;
    }

    public String getProcessLog() {
        return this.processLog;
    }

    @Deprecated
    public void setProcessLog(String processLog) {
        this.processLog = processLog;
    }

    public BuildExecutionConfigurationRest getBuildExecutionConfiguration() {
        return this.buildExecutionConfiguration;
    }

    @Deprecated
    public void setBuildExecutionConfiguration(BuildExecutionConfigurationRest buildExecutionConfiguration) {
        this.buildExecutionConfiguration = buildExecutionConfiguration;
    }

    public BuildDriverResultRest getBuildDriverResult() {
        return this.buildDriverResult;
    }

    @Deprecated
    public void setBuildDriverResult(BuildDriverResultRest buildDriverResult) {
        this.buildDriverResult = buildDriverResult;
    }

    public RepositoryManagerResultRest getRepositoryManagerResult() {
        return this.repositoryManagerResult;
    }

    @Deprecated
    public void setRepositoryManagerResult(RepositoryManagerResultRest repositoryManagerResult) {
        this.repositoryManagerResult = repositoryManagerResult;
    }

    public EnvironmentDriverResult getEnvironmentDriverResult() {
        return this.environmentDriverResult;
    }

    @Deprecated
    public void setEnvironmentDriverResult(EnvironmentDriverResult environmentDriverResult) {
        this.environmentDriverResult = environmentDriverResult;
    }

    public RepourResult getRepourResult() {
        return this.repourResult;
    }

    @Deprecated
    public void setRepourResult(RepourResult repourResult) {
        this.repourResult = repourResult;
    }

    class RepositoryManagerResultImpl
    implements RepositoryManagerResult {
        private RepositoryManagerResult repositoryManagerResult;
        private int maxStringLength;

        public RepositoryManagerResultImpl(RepositoryManagerResult repositoryManagerResult, int maxStringLength) {
            this.repositoryManagerResult = repositoryManagerResult;
            this.maxStringLength = maxStringLength;
        }

        public List<Artifact> getBuiltArtifacts() {
            return this.repositoryManagerResult.getBuiltArtifacts();
        }

        public List<Artifact> getDependencies() {
            return this.repositoryManagerResult.getDependencies();
        }

        public String getBuildContentId() {
            return this.repositoryManagerResult.getBuildContentId();
        }

        public String getLog() {
            return StringUtils.trim((String)this.repositoryManagerResult.getLog(), (int)this.maxStringLength);
        }

        public CompletionStatus getCompletionStatus() {
            return this.repositoryManagerResult.getCompletionStatus();
        }
    }
}

